/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.components.issueviewer.action;

import com.atlassian.jira.issue.Issue;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class IssuePager {
    @XmlElement
    private IssueDescriptor nextIssue;
    @XmlElement
    private int position;
    @XmlElement
    private IssueDescriptor previousIssue;
    @XmlElement
    private int resultCount;

    public IssuePager(Issue nextIssue, int position, Issue previousIssue, int resultCount) {
        this.position = position;
        this.resultCount = resultCount;
        if (nextIssue != null) {
            this.nextIssue = new IssueDescriptor(nextIssue);
        }
        if (previousIssue != null) {
            this.previousIssue = new IssueDescriptor(previousIssue);
        }
    }

    public IssueDescriptor getNextIssue() {
        return this.nextIssue;
    }

    public int getPosition() {
        return this.position;
    }

    public IssueDescriptor getPreviousIssue() {
        return this.previousIssue;
    }

    public int getResultCount() {
        return this.resultCount;
    }

    @XmlRootElement
    public static class IssueDescriptor {
        @XmlElement
        private Long id;
        @XmlElement
        private String key;

        public IssueDescriptor(Issue issue) {
            this.id = issue.getId();
            this.key = issue.getKey();
        }

        public Long getId() {
            return this.id;
        }

        public String getKey() {
            return this.key;
        }
    }
}

