/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.components.issueviewer.action;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.rest.json.beans.ProjectJsonBean;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.type.ProjectTypeKey;
import com.atlassian.jira.rest.v2.issue.OpsbarBean;
import java.util.Map;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang.builder.ToStringBuilder;

@XmlRootElement
public class IssueBean {
    @XmlElement
    private Long id;
    @XmlElement
    private String key;
    @XmlElement
    private Map<String, String> metadata;
    @XmlElement
    private OpsbarBean operations;
    @XmlElement
    private IssueBean parent;
    @XmlElement
    private IssueProjectBean project;
    @XmlElement
    private IssueStatusBean status;
    @XmlElement
    private String summary;
    @XmlElement
    private String summaryContentId;
    @XmlElement
    private boolean isEditable;

    private IssueBean() {
    }

    public IssueBean(Issue issue, boolean includeSummary) {
        this.id = issue.getId();
        this.key = issue.getKey();
        if (includeSummary) {
            this.summary = issue.getSummary();
        }
    }

    public IssueBean(Issue issue, Map<String, String> metadata, OpsbarBean operations, Project project, Status status, String summaryContentId, boolean includeSummary, boolean isEditable) {
        this(issue, includeSummary);
        this.metadata = metadata;
        this.operations = operations;
        this.summaryContentId = summaryContentId;
        this.project = new IssueProjectBean(project);
        this.status = new IssueStatusBean(status);
        this.isEditable = isEditable;
        Issue parent = issue.getParentObject();
        if (null != parent) {
            this.parent = new IssueBean(parent, true);
        }
    }

    public Long getId() {
        return this.id;
    }

    public String getKey() {
        return this.key;
    }

    public String getSummary() {
        return this.summary;
    }

    public OpsbarBean getOperations() {
        return this.operations;
    }

    public IssueProjectBean getProject() {
        return this.project;
    }

    public IssueStatusBean getStatus() {
        return this.status;
    }

    public IssueBean getParent() {
        return this.parent;
    }

    public String getSummaryContentId() {
        return this.summaryContentId;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("id", (Object)this.id).append("key", (Object)this.key).append("operations", (Object)this.operations).toString();
    }

    @XmlRootElement
    public static class IssueStatusBean {
        @XmlElement(name="description")
        private String description;
        @XmlElement(name="iconUrl")
        private String iconUrl;
        @XmlElement(name="name")
        private String name;
        @XmlElement(name="id")
        private String id;

        private IssueStatusBean() {
        }

        public IssueStatusBean(Status status) {
            this.description = status.getDescription();
            this.iconUrl = status.getIconUrl();
            this.name = status.getName();
            this.id = status.getId();
        }

        public String getDescription() {
            return this.description;
        }

        public String getIconUrl() {
            return this.iconUrl;
        }

        public String getName() {
            return this.name;
        }

        public String getId() {
            return this.id;
        }
    }

    @XmlRootElement
    public static class IssueProjectBean {
        @XmlElement(name="id")
        private Long id;
        @XmlElement(name="key")
        private String key;
        @XmlElement(name="projectType")
        private String projectType;
        @XmlElement(name="name")
        private String name;
        @XmlElement(name="avatarUrls")
        private Map<String, String> avatarUrls;
        @XmlElement
        private boolean systemAvatar;

        private IssueProjectBean() {
        }

        public IssueProjectBean(Project project) {
            this.id = project.getId();
            this.key = project.getKey();
            ProjectTypeKey projectTypeKey = project.getProjectTypeKey();
            this.projectType = projectTypeKey == null ? "" : projectTypeKey.getKey();
            this.name = project.getName();
            this.avatarUrls = ProjectJsonBean.getAvatarUrls((Project)project);
            this.systemAvatar = project.getAvatar().isSystemAvatar();
        }

        public Long getId() {
            return this.id;
        }

        public String getKey() {
            return this.key;
        }

        public String getName() {
            return this.name;
        }

        public Map<String, String> getAvatarUrls() {
            return this.avatarUrls;
        }

        public boolean isSystemAvatar() {
            return this.systemAvatar;
        }

        public String getProjectType() {
            return this.projectType;
        }
    }
}

