/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.components.issueeditor.action;

import com.atlassian.jira.components.issueeditor.action.ContentIdCollector;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.digest.DigestUtils;

public class DefaultContentIdCollector
implements ContentIdCollector {
    private final Long lastReadTime;
    private final Map<String, Map<String, String>> currentContentIds;
    private final Map<String, Collection<String>> newKeys;

    DefaultContentIdCollector(HttpServletRequest request, Long lastReadTime) {
        this.lastReadTime = lastReadTime;
        HashMap contentIdMap = Maps.newHashMap();
        DefaultContentIdCollector.populateCurrentMappingForCategory("issue", contentIdMap, request);
        DefaultContentIdCollector.populateCurrentMappingForCategory("fields", contentIdMap, request);
        DefaultContentIdCollector.populateCurrentMappingForCategory("links", contentIdMap, request);
        DefaultContentIdCollector.populateCurrentMappingForCategory("panels", contentIdMap, request);
        this.currentContentIds = contentIdMap.isEmpty() ? null : contentIdMap;
        this.newKeys = Maps.newHashMap();
    }

    private static void populateCurrentMappingForCategory(String category, Map<String, Map<String, String>> contentIdMap, HttpServletRequest request) {
        HashMap mapping = Maps.newHashMap();
        String[] fieldsParams = request.getParameterValues(category);
        if (fieldsParams != null) {
            for (String value : fieldsParams) {
                int lastSeparatorIndex = value.lastIndexOf(":");
                String name = value.substring(0, lastSeparatorIndex);
                String contentId = value.substring(lastSeparatorIndex + 1);
                mapping.put(name, contentId);
            }
        }
        if (!mapping.isEmpty()) {
            contentIdMap.put(category, mapping);
        }
    }

    @Override
    public String calculateContentId(String calculateFrom) {
        return DigestUtils.md5Hex((String)calculateFrom);
    }

    @Override
    public boolean mustLoadAll() {
        return this.currentContentIds == null;
    }

    @Override
    public String getCurrentFieldContentId(String key) {
        return this.getCurrentContentId("fields", key);
    }

    @Override
    public String getCurrentLinkContentId(String key) {
        return this.getCurrentContentId("links", key);
    }

    @Override
    public String getCurrentPanelContentId(String key) {
        return this.getCurrentContentId("panels", key);
    }

    @Override
    public String getCurrentIssueContentId(String key) {
        return this.getCurrentContentId("issue", key);
    }

    private String getCurrentContentId(String category, String key) {
        if (this.currentContentIds == null) {
            return null;
        }
        Map<String, String> categoryMapping = this.currentContentIds.get(category);
        if (categoryMapping == null) {
            return null;
        }
        return categoryMapping.get(key);
    }

    @Override
    public void addNewFieldKey(String key) {
        this.addNewKey("fields", key);
    }

    @Override
    public void addNewLinkKey(String key) {
        this.addNewKey("links", key);
    }

    @Override
    public void addNewPanelKey(String key) {
        this.addNewKey("panels", key);
    }

    private void addNewKey(String category, String key) {
        ArrayList keys = this.newKeys.get(category);
        if (keys == null) {
            keys = Lists.newArrayList();
            this.newKeys.put(category, keys);
        }
        keys.add(key);
    }

    @Override
    public Map<String, Collection<String>> getRemovedContentIds() {
        HashMap removedKeys = Maps.newHashMap();
        if (this.currentContentIds != null) {
            for (Map.Entry<String, Map<String, String>> currentEntry : this.currentContentIds.entrySet()) {
                String category = currentEntry.getKey();
                if ("issue".equals(category)) continue;
                Map<String, String> mapping = currentEntry.getValue();
                ArrayList keys = Lists.newArrayList(mapping.keySet());
                Collection<String> newKeysForCategory = this.newKeys.get(category);
                if (newKeysForCategory != null) {
                    keys.removeAll(newKeysForCategory);
                }
                removedKeys.put(category, keys);
            }
        }
        return removedKeys;
    }

    @Override
    public Long getLastReadTime() {
        return this.lastReadTime;
    }
}

