/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.asana.transformers;

import com.atlassian.jira.plugins.importer.asana.AsanaConfigBean;
import com.atlassian.jira.plugins.importer.asana.rest.beans.Project;
import com.atlassian.jira.plugins.importer.external.beans.ExternalProject;
import com.google.common.base.Function;

public class ProjectTransformer
implements Function<Project, ExternalProject> {
    private AsanaConfigBean configBean;

    public ProjectTransformer(AsanaConfigBean configBean) {
        this.configBean = configBean;
    }

    public ExternalProject apply(Project project) {
        ExternalProject externalProject = new ExternalProject(project.getName(), this.configBean.getProjectKey(project.getName()));
        externalProject.setId(project.getExternalId());
        externalProject.setDescription(project.getNotes());
        if (this.configBean.getValueMappingHelper().getWorkflowSchemeName().equals("[none-default-workflow]")) {
            externalProject.setWorkflowSchemeName("classic");
        } else {
            externalProject.setWorkflowSchemeName(this.configBean.getValueMappingHelper().getWorkflowSchemeName());
        }
        return externalProject;
    }
}

