/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.asana.transformers;

import com.atlassian.fugue.Option;
import com.atlassian.jira.plugins.importer.asana.rest.beans.Attachment;
import com.atlassian.jira.plugins.importer.external.beans.ExternalAttachment;
import com.atlassian.jira.plugins.importer.imports.importer.ImportLogger;
import com.google.common.base.Function;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.apache.commons.io.FileUtils;

public class AttachmentTransformer
implements Function<Attachment, Option<ExternalAttachment>> {
    private final ImportLogger importLogger;

    public AttachmentTransformer(ImportLogger importLogger) {
        this.importLogger = importLogger;
    }

    public Option<ExternalAttachment> apply(Attachment attachment) {
        try {
            File tempFile = File.createTempFile(attachment.getName(), null);
            FileUtils.copyURLToFile((URL)new URL(attachment.getDownload_url()), (File)tempFile);
            ExternalAttachment externalAttachment = new ExternalAttachment(attachment.getName(), tempFile, attachment.getCreated_at());
            externalAttachment.setAttacher("admin");
            return Option.some((Object)externalAttachment);
        }
        catch (IOException e) {
            this.importLogger.warn((Throwable)e, "Couldn't import attachment with name %s and ID %s", new Object[]{attachment.getName(), attachment.getId()});
            return Option.none();
        }
    }
}

