/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.asana.rest;

import com.atlassian.fugue.Option;
import com.atlassian.jira.plugins.importer.asana.rest.AsanaRemoteException;
import com.atlassian.jira.plugins.importer.asana.rest.PagedResult;
import com.atlassian.jira.plugins.importer.asana.rest.beans.NextPage;
import com.atlassian.jira.plugins.importer.imports.importer.ImportLogger;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

public class ThrottlingCaller {
    public static final String ROOT_URL = "https://app.asana.com/api/1.0/";
    private final Client client;
    public static final int HTTP_CODE_RATE_LIMIT_ENFORCED = 429;

    public ThrottlingCaller(Client client) {
        this.client = client;
    }

    public <T> T call(String endpoint, Class<T> clazz, Option<ImportLogger> log) {
        return this.call(endpoint, clazz, (Map<String, String>)ImmutableMap.of(), log);
    }

    public <T> T call(String endpoint, Class<T> clazz, Map<String, String> params, Option<ImportLogger> log) {
        return this.pagedCall(endpoint, clazz, params, log).getData();
    }

    public <T> PagedResult<T> pagedCall(String endpoint, Class<T> clazz, Map<String, String> params, Option<ImportLogger> log) {
        WebResource resource = this.client.resource(ROOT_URL + endpoint);
        for (String param : params.keySet()) {
            resource = resource.queryParam(param, params.get(param));
        }
        ClientResponse response = (ClientResponse)resource.get(ClientResponse.class);
        if (response.getStatus() == 429) {
            int retryAfter = Integer.parseInt((String)((List)response.getHeaders().get((Object)"Retry-After")).get(0));
            try {
                response.close();
                Thread.sleep(retryAfter);
                return this.pagedCall(endpoint, clazz, params, log);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        if (response.getStatus() < 300) {
            return this.parseResponse(clazz, response);
        }
        String errorMessage = this.extractErrorMessage(response);
        response.close();
        if (log.isDefined()) {
            ((ImportLogger)log.get()).warn("Asana Importer has returned an error for request: " + resource.getURI().toString(), new Object[0]);
            ((ImportLogger)log.get()).warn("Asana response: " + errorMessage, new Object[0]);
        }
        throw new AsanaRemoteException("Asana API exception: " + response.getStatus());
    }

    private String extractErrorMessage(ClientResponse response) {
        try {
            return (String)response.getEntity(String.class);
        }
        catch (ClientHandlerException e) {
            throw new AsanaRemoteException("Cannot read Asana respone", e);
        }
        catch (UniformInterfaceException e) {
            throw new AsanaRemoteException("Cannot read Asana respone", e);
        }
    }

    private <T> PagedResult<T> parseResponse(Class<T> clazz, ClientResponse response) {
        String json = (String)response.getEntity(String.class);
        Gson gson = new GsonBuilder().registerTypeAdapter((Type)((Object)Date.class), new UtcDateDeserializer()).create();
        JsonObject jsonObject = (JsonObject)new JsonParser().parse(json);
        response.close();
        PagedResult<T> pagedResult = new PagedResult<T>(gson.fromJson(jsonObject.get("data"), clazz), gson.fromJson(jsonObject.get("next_page"), NextPage.class));
        return pagedResult;
    }

    private class UtcDateDeserializer
    implements JsonDeserializer<Date> {
        private UtcDateDeserializer() {
        }

        @Override
        public Date deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            try {
                return simpleDateFormat.parse(jsonElement.getAsString());
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

