/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.asana.rest;

import com.atlassian.fugue.Option;
import com.atlassian.jira.plugins.importer.asana.rest.AsanaClient;
import com.atlassian.jira.plugins.importer.asana.rest.PagedResult;
import com.atlassian.jira.plugins.importer.asana.rest.ThrottlingCaller;
import com.atlassian.jira.plugins.importer.asana.rest.beans.Attachment;
import com.atlassian.jira.plugins.importer.asana.rest.beans.Project;
import com.atlassian.jira.plugins.importer.asana.rest.beans.Story;
import com.atlassian.jira.plugins.importer.asana.rest.beans.Tag;
import com.atlassian.jira.plugins.importer.asana.rest.beans.Task;
import com.atlassian.jira.plugins.importer.asana.rest.beans.User;
import com.atlassian.jira.plugins.importer.asana.rest.beans.Workspace;
import com.atlassian.jira.plugins.importer.asana.rest.beans.WorkspaceStubProject;
import com.atlassian.jira.plugins.importer.asana.rest.beans.collections.Attachments;
import com.atlassian.jira.plugins.importer.asana.rest.beans.collections.Projects;
import com.atlassian.jira.plugins.importer.asana.rest.beans.collections.Stories;
import com.atlassian.jira.plugins.importer.asana.rest.beans.collections.Tags;
import com.atlassian.jira.plugins.importer.asana.rest.beans.collections.Tasks;
import com.atlassian.jira.plugins.importer.asana.rest.beans.collections.Users;
import com.atlassian.jira.plugins.importer.asana.rest.beans.collections.Workspaces;
import com.atlassian.jira.plugins.importer.imports.importer.ImportLogger;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.HTTPBasicAuthFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class AsanaRestClient
implements AsanaClient {
    public static final int TASKS_PER_PAGE = 50;
    public static final int USERS_PER_PAGE = 50;
    private static final List<String> TASK_OPT_FIELDS = ImmutableList.of((Object)"assignee", (Object)"assignee.email", (Object)"assignee_status", (Object)"created_at", (Object)"completed", (Object)"completed_at", (Object)"due_at", (Object)"followers", (Object)"followers.email", (Object)"hearts.user.email", (Object)"modified_at", (Object)"name", (Object[])new String[]{"notes", "num_hearts", "parent", "parent.projects", "created_by", "created_by.email", "stories", "stories.type", "stories.text", "stories.created_at", "stories.created_by.email", "attachments", "attachments.created_at", "attachments.download_url", "attachments.name", "subtasks", "tags", "tags.name"});
    public static final List<String> USER_OPT_FIELDS = ImmutableList.of((Object)"name", (Object)"email", (Object)"workspaces");
    private final ThrottlingCaller throttlingCaller;

    @Override
    public User getMe() {
        return this.throttlingCaller.call("users/me", User.class, (Option<ImportLogger>)Option.none(ImportLogger.class));
    }

    @Override
    public PagedResult<Users> getAllUsersInWorkspace(long workspaceId, Optional<String> offsetToken, ImportLogger log) {
        ImmutableMap.Builder paramsBuilder = ImmutableMap.builder();
        paramsBuilder.put((Object)"opt_fields", (Object)Joiner.on((String)",").join(USER_OPT_FIELDS));
        paramsBuilder.put((Object)"limit", (Object)Integer.toString(50));
        if (offsetToken.isPresent()) {
            paramsBuilder.put((Object)"offset", offsetToken.get());
        }
        ImmutableMap params = paramsBuilder.build();
        return this.throttlingCaller.pagedCall("workspaces/" + Long.toString(workspaceId) + "/users", Users.class, (Map<String, String>)params, (Option<ImportLogger>)Option.option((Object)log));
    }

    @Override
    public List<Workspace> getWorkspaces(ImportLogger log) {
        return this.throttlingCaller.call("workspaces", Workspaces.class, (Option<ImportLogger>)Option.option((Object)log));
    }

    @Override
    public List<Project> getAllProjects(ImportLogger log) {
        List projects = this.throttlingCaller.call("projects", Projects.class, (Map<String, String>)ImmutableMap.of((Object)"opt_fields", (Object)"name,notes"), (Option<ImportLogger>)Option.option((Object)log));
        projects.addAll(this.getAllWorkspaceStubProjects(log));
        return projects;
    }

    public List<Project> getAllWorkspaceStubProjects(ImportLogger log) {
        List workspaces = this.throttlingCaller.call("workspaces", Workspaces.class, (Option<ImportLogger>)Option.option((Object)log));
        return Lists.newArrayList((Iterable)Collections2.transform((Collection)workspaces, (Function)new Function<Workspace, WorkspaceStubProject>(){

            public WorkspaceStubProject apply(Workspace input) {
                WorkspaceStubProject project = new WorkspaceStubProject(input);
                return project;
            }
        }));
    }

    @Override
    public List<Project> getAllProjectsInWorkspaces(Collection<Workspace> workspaces, ImportLogger log) {
        ArrayList<Project> projects = new ArrayList<Project>();
        for (Workspace workspace : workspaces) {
            String endpoint = "workspaces/" + workspace.getId() + "/projects";
            projects.addAll(this.throttlingCaller.call(endpoint, Projects.class, (Option<ImportLogger>)Option.option((Object)log)));
        }
        return projects;
    }

    @Override
    public PagedResult<Tasks> getTasks(long projectId, Optional<String> offsetToken, ImportLogger log) {
        String endpoint = "projects/" + projectId + "/tasks";
        ImmutableMap.Builder paramsBuilder = ImmutableMap.builder();
        paramsBuilder.put((Object)"opt_fields", (Object)Joiner.on((String)",").join(TASK_OPT_FIELDS));
        paramsBuilder.put((Object)"limit", (Object)Integer.toString(50));
        if (offsetToken.isPresent()) {
            paramsBuilder.put((Object)"offset", offsetToken.get());
        }
        ImmutableMap params = paramsBuilder.build();
        PagedResult<Tasks> result = this.throttlingCaller.pagedCall(endpoint, Tasks.class, (Map<String, String>)params, (Option<ImportLogger>)Option.option((Object)log));
        return result;
    }

    @Override
    public PagedResult<Tasks> getTasks(User user, long workspaceId, Optional<String> offsetToken, ImportLogger log) {
        Preconditions.checkNotNull((Object)user);
        Preconditions.checkNotNull((Object)workspaceId);
        String endpoint = "tasks";
        ImmutableMap.Builder paramsBuilder = ImmutableMap.builder();
        paramsBuilder.put((Object)"assignee", (Object)user.getId().toString());
        paramsBuilder.put((Object)"workspace", (Object)Long.toString(workspaceId));
        paramsBuilder.put((Object)"opt_fields", (Object)Joiner.on((String)",").join(TASK_OPT_FIELDS));
        paramsBuilder.put((Object)"limit", (Object)Integer.toString(50));
        if (offsetToken.isPresent()) {
            paramsBuilder.put((Object)"offset", offsetToken.get());
        }
        ImmutableMap params = paramsBuilder.build();
        return this.throttlingCaller.pagedCall(endpoint, Tasks.class, (Map<String, String>)params, (Option<ImportLogger>)Option.option((Object)log));
    }

    @Override
    public List<String> getAllProjectNames(ImportLogger log) {
        ArrayList projectNames = Lists.newArrayList((Iterable)Iterables.transform((Iterable)this.throttlingCaller.call("projects", Projects.class, (Option<ImportLogger>)Option.option((Object)log)), (Function)new Function<Project, String>(){

            public String apply(Project project) {
                return project.getName();
            }
        }));
        projectNames.addAll(Collections2.transform(this.getAllWorkspaceStubProjects(log), (Function)new Function<Project, String>(){

            public String apply(Project project) {
                return project.getName();
            }
        }));
        return projectNames;
    }

    @Override
    public Task getTask(long taskId, ImportLogger log) {
        String endpoint = "tasks/" + taskId;
        return this.throttlingCaller.call(endpoint, Task.class, (Map<String, String>)ImmutableMap.of((Object)"opt_fields", (Object)Joiner.on((String)",").join(TASK_OPT_FIELDS)), (Option<ImportLogger>)Option.option((Object)log));
    }

    @Override
    public List<Story> getStories(long taskId, ImportLogger log) {
        ImmutableMap params = ImmutableMap.of((Object)"opt_fields", (Object)"type,text,created_at,created_by.email");
        return this.throttlingCaller.call("tasks/" + taskId + "/stories", Stories.class, (Map<String, String>)params, (Option<ImportLogger>)Option.option((Object)log));
    }

    @Override
    public List<Attachment> getAttachments(long taskId, ImportLogger log) {
        return this.throttlingCaller.call("tasks/" + taskId + "/attachments", Attachments.class, (Map<String, String>)ImmutableMap.of((Object)"opt_fields", (Object)"created_at,download_url,host,parent,view_url,name"), (Option<ImportLogger>)Option.option((Object)log));
    }

    @Override
    public List<Tag> getTags(long taskId, ImportLogger log) {
        return this.throttlingCaller.call("tasks/" + taskId + "/tags", Tags.class, (Map<String, String>)ImmutableMap.of((Object)"opt_fields", (Object)"name"), (Option<ImportLogger>)Option.option((Object)log));
    }

    public AsanaRestClient(String apiKey) {
        DefaultClientConfig clientConfig = new DefaultClientConfig();
        Client client = Client.create((ClientConfig)clientConfig);
        client.addFilter((ClientFilter)new HTTPBasicAuthFilter(apiKey, ""));
        this.throttlingCaller = new ThrottlingCaller(client);
    }

    @VisibleForTesting
    public AsanaRestClient(ThrottlingCaller caller) {
        this.throttlingCaller = caller;
    }
}

