/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.asana;

import com.atlassian.jira.plugins.importer.asana.AsanaConfigBean;
import com.atlassian.jira.plugins.importer.asana.rest.AsanaClient;
import com.atlassian.jira.plugins.importer.asana.rest.PagedResult;
import com.atlassian.jira.plugins.importer.asana.rest.beans.User;
import com.atlassian.jira.plugins.importer.asana.rest.beans.collections.Users;
import com.atlassian.jira.plugins.importer.imports.importer.ImportLogger;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import java.util.Iterator;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserInWorkspaceIterator
implements Iterator<User> {
    private static final Logger log = LoggerFactory.getLogger(UserInWorkspaceIterator.class);
    private final long workspaceId;
    private final ImportLogger importLogger;
    private final AsanaClient client;
    private final AsanaConfigBean configBean;
    private String offset;
    protected Iterator<User> buffer;
    private boolean hasNextPage;

    public UserInWorkspaceIterator(long workspaceId, AsanaConfigBean asanaConfigBean, ImportLogger importLogger) {
        this.workspaceId = workspaceId;
        this.client = asanaConfigBean.getClient();
        this.configBean = asanaConfigBean;
        this.importLogger = importLogger;
    }

    @Override
    public boolean hasNext() {
        if (this.buffer == null || !this.buffer.hasNext()) {
            this.loadNextPage();
        }
        return this.buffer.hasNext() || this.hasNextPage;
    }

    @Override
    public User next() {
        User next;
        if (this.buffer == null || this.hasNextPage && !this.buffer.hasNext()) {
            this.loadNextPage();
        }
        if (StringUtils.isBlank((CharSequence)(next = this.buffer.next()).getEmail())) {
            this.importLogger.warn("User %s doesn't have mail address defined. This may cause import to fail", new Object[]{next});
        }
        return next;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not implemented");
    }

    protected void loadNextPage() {
        if (this.buffer == null || this.hasNextPage) {
            PagedResult<Users> userList = this.client.getAllUsersInWorkspace(this.workspaceId, (Optional<String>)Optional.fromNullable((Object)this.offset), this.importLogger);
            Users data = userList.getData();
            this.hasNextPage = false;
            if (data == null) {
                this.buffer = ImmutableList.of().iterator();
            } else {
                this.buffer = data.iterator();
                if (userList.getNext_page() != null) {
                    this.offset = userList.getNext_page().getOffset();
                    this.hasNextPage = true;
                }
            }
        }
    }
}

