/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.asana;

import com.atlassian.jira.plugins.importer.asana.AsanaConfigBean;
import com.atlassian.jira.plugins.importer.asana.rest.beans.Task;
import com.atlassian.jira.plugins.importer.asana.rest.beans.collections.Tasks;
import com.atlassian.jira.plugins.importer.asana.transformers.TaskTransformer;
import com.atlassian.jira.plugins.importer.external.beans.ExternalIssue;
import com.atlassian.jira.plugins.importer.imports.importer.ImportLogger;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.ArrayDeque;
import java.util.Iterator;

public class SinglePageTaskIterator
implements Iterator<ExternalIssue> {
    public static final Predicate<Task> NO_PARENT_PREDICATE = new Predicate<Task>(){

        public boolean apply(Task input) {
            return input.getParent() == null;
        }
    };
    private final AsanaConfigBean configBean;
    private final Iterator<Task> taskListBuffer;
    private final ArrayDeque<Long> subtaskIds = new ArrayDeque();
    private final TaskTransformer taskTransformer;
    private final ImportLogger importLogger;

    public SinglePageTaskIterator(Tasks tasks, AsanaConfigBean configBean, TaskTransformer taskTransformer, ImportLogger importLogger) {
        this.configBean = configBean;
        this.taskTransformer = taskTransformer;
        this.importLogger = importLogger;
        this.taskListBuffer = Iterables.filter((Iterable)tasks, NO_PARENT_PREDICATE).iterator();
    }

    @Override
    public boolean hasNext() {
        return this.taskListBuffer.hasNext() || this.subtaskIds.size() > 0;
    }

    @Override
    public ExternalIssue next() {
        Task task = this.subtaskIds.isEmpty() ? this.taskListBuffer.next() : this.configBean.getClient().getTask(this.subtaskIds.poll(), this.importLogger);
        ExternalIssue externalIssue = this.taskTransformer.apply(task);
        if (this.configBean.getIssueInMultipleProjectsHolder() != null) {
            this.configBean.getIssueInMultipleProjectsHolder().registerIssue(task.getId(), externalIssue);
        }
        for (Task subtask : task.getSubtasks()) {
            this.subtaskIds.add(subtask.getId());
        }
        return externalIssue;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not implemented");
    }
}

