/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.asana;

import com.atlassian.jira.plugins.importer.asana.AbstractMultiPageTaskIterator;
import com.atlassian.jira.plugins.importer.asana.AsanaConfigBean;
import com.atlassian.jira.plugins.importer.asana.UserInWorkspaceIterator;
import com.atlassian.jira.plugins.importer.asana.rest.PagedResult;
import com.atlassian.jira.plugins.importer.asana.rest.beans.User;
import com.atlassian.jira.plugins.importer.asana.rest.beans.collections.Tasks;
import com.atlassian.jira.plugins.importer.external.beans.ExternalIssue;
import com.atlassian.jira.plugins.importer.imports.importer.ImportLogger;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ProjectlessTaskIterator
implements Iterator<ExternalIssue> {
    private Iterator<User> userIterator;
    private long workspaceId;
    private final AsanaConfigBean asanaConfigBean;
    private final ImportLogger importLogger;
    private Iterator<ExternalIssue> currentUserTasksIterator;
    private IteratorsFactory iteratorsFactory;

    public ProjectlessTaskIterator(long workspaceId, AsanaConfigBean asanaConfigBean, ImportLogger importLogger) {
        this.workspaceId = workspaceId;
        this.asanaConfigBean = asanaConfigBean;
        this.importLogger = importLogger;
        this.iteratorsFactory = this.getIteratorsFactory();
        this.userIterator = this.iteratorsFactory.getUsersIterator(workspaceId, asanaConfigBean, importLogger);
    }

    @VisibleForTesting
    protected IteratorsFactory getIteratorsFactory() {
        return new IteratorsFactory();
    }

    @Override
    public boolean hasNext() {
        if (this.currentUserTasksIterator == null || !this.currentUserTasksIterator.hasNext()) {
            this.loadNextUser();
        }
        return this.currentUserTasksIterator != null && this.currentUserTasksIterator.hasNext();
    }

    private void loadNextUser() {
        do {
            if (!this.userIterator.hasNext()) {
                this.currentUserTasksIterator = null;
                return;
            }
            this.currentUserTasksIterator = this.iteratorsFactory.getSingleUserTaskIterator(this.userIterator.next());
        } while (!this.currentUserTasksIterator.hasNext());
    }

    @Override
    public ExternalIssue next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.currentUserTasksIterator.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public class IteratorsFactory {
        public Iterator<ExternalIssue> getSingleUserTaskIterator(User user) {
            return new SingleUserTaskIterator(user);
        }

        public Iterator<User> getUsersIterator(long workspaceId, AsanaConfigBean asanaConfigBean, ImportLogger importLogger) {
            return new UserInWorkspaceIterator(workspaceId, asanaConfigBean, importLogger);
        }
    }

    private class SingleUserTaskIterator
    extends AbstractMultiPageTaskIterator {
        private final User user;

        private SingleUserTaskIterator(User user) {
            super(-1L, ProjectlessTaskIterator.this.asanaConfigBean, ProjectlessTaskIterator.this.importLogger);
            this.user = user;
        }

        @Override
        protected PagedResult<Tasks> getNextTasks(String currentOffset) {
            return ProjectlessTaskIterator.this.asanaConfigBean.getClient().getTasks(this.user, ProjectlessTaskIterator.this.workspaceId, (Optional<String>)Optional.fromNullable((Object)currentOffset), ProjectlessTaskIterator.this.importLogger);
        }
    }
}

