/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.asana;

import com.atlassian.jira.issue.link.IssueLinkTypeManager;
import com.atlassian.jira.plugins.importer.asana.AsanaConfigBean;
import com.atlassian.jira.plugins.importer.asana.AsanaDataBean;
import com.atlassian.jira.plugins.importer.asana.rest.AsanaRemoteException;
import com.atlassian.jira.plugins.importer.asana.rest.AsanaRestClient;
import com.atlassian.jira.plugins.importer.asana.web.AsanaSetupPage;
import com.atlassian.jira.plugins.importer.imports.importer.AbstractConfigBean;
import com.atlassian.jira.plugins.importer.imports.importer.ImportDataBean;
import com.atlassian.jira.plugins.importer.imports.importer.JiraDataImporter;
import com.atlassian.jira.plugins.importer.web.AbstractImporterController;
import com.atlassian.jira.plugins.importer.web.AbstractSetupPage;
import com.atlassian.jira.plugins.importer.web.ImportProcessBean;
import com.atlassian.jira.plugins.importer.web.ImporterCustomFieldsPage;
import com.atlassian.jira.plugins.importer.web.ImporterFieldMappingsPage;
import com.atlassian.jira.plugins.importer.web.ImporterLinksPage;
import com.atlassian.jira.plugins.importer.web.ImporterProjectMappingsPage;
import com.atlassian.jira.plugins.importer.web.ImporterValueMappingsPage;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class AsanaImporterController
extends AbstractImporterController {
    public static final String IMPORT_CONFIG_BEAN = "com.atlassian.jira.plugins.importer.asana.config";
    public static final String IMPORT_ID = "asana";
    private IssueLinkTypeManager issueLinkTypeManager;

    public AsanaImporterController(@ComponentImport JiraDataImporter importer, @ComponentImport IssueLinkTypeManager issueLinkTypeManager) {
        super(importer, IMPORT_CONFIG_BEAN, IMPORT_ID);
        this.issueLinkTypeManager = issueLinkTypeManager;
    }

    public boolean createImportProcessBean(AbstractSetupPage abstractSetupPage) {
        AsanaSetupPage asanaSetupPage = (AsanaSetupPage)abstractSetupPage;
        AsanaRestClient client = new AsanaRestClient(asanaSetupPage.getAsanaApiKey());
        this.validateConnection(asanaSetupPage);
        ImportProcessBean importProcessBean = new ImportProcessBean();
        importProcessBean.setConfigBean((AbstractConfigBean)new AsanaConfigBean(client));
        this.storeImportProcessBeanInSession(importProcessBean);
        return true;
    }

    public ImportDataBean createDataBean() throws Exception {
        AsanaConfigBean configBean = (AsanaConfigBean)this.getImportProcessBeanFromSession().getConfigBean();
        return new AsanaDataBean(configBean, this.issueLinkTypeManager);
    }

    public List<String> getSteps() {
        return ImmutableList.of((Object)AsanaSetupPage.class.getSimpleName(), (Object)ImporterProjectMappingsPage.class.getSimpleName(), (Object)ImporterCustomFieldsPage.class.getSimpleName(), (Object)ImporterFieldMappingsPage.class.getSimpleName(), (Object)ImporterValueMappingsPage.class.getSimpleName(), (Object)ImporterLinksPage.class.getSimpleName());
    }

    public List<String> getStepNameKeys() {
        return ImmutableList.of((Object)"jira-importer-plugin.wizard.step.AsanaSetupPage", (Object)"jira-importer-plugin.wizard.step.ImporterProjectMappingsPage", (Object)"jira-importer-plugin.wizard.step.ImporterCustomFieldsPage", (Object)"jira-importer-plugin.wizard.step.ImporterFieldMappingsPage", (Object)"jira-importer-plugin.wizard.step.ImporterValueMappingsPage", (Object)"jira-importer-plugin.wizard.step.ImporterLinksPage");
    }

    private void validateConnection(AsanaSetupPage asanaSetupPage) {
        try {
            AsanaRestClient client = new AsanaRestClient(asanaSetupPage.getAsanaApiKey());
            client.getMe();
        }
        catch (AsanaRemoteException e) {
            asanaSetupPage.addErrorMessage("Unable to connect to Asana: " + e.getMessage());
        }
    }
}

