/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.asana;

import com.atlassian.jira.issue.link.IssueLinkTypeManager;
import com.atlassian.jira.plugins.importer.asana.AsanaConfigBean;
import com.atlassian.jira.plugins.importer.asana.ProjectlessTaskIterator;
import com.atlassian.jira.plugins.importer.asana.TaskIterator;
import com.atlassian.jira.plugins.importer.asana.UserInWorkspaceIterator;
import com.atlassian.jira.plugins.importer.asana.rest.AsanaClient;
import com.atlassian.jira.plugins.importer.asana.rest.beans.Project;
import com.atlassian.jira.plugins.importer.asana.rest.beans.Workspace;
import com.atlassian.jira.plugins.importer.asana.transformers.ProjectTransformer;
import com.atlassian.jira.plugins.importer.asana.transformers.UserTransformer;
import com.atlassian.jira.plugins.importer.external.beans.ExternalAttachment;
import com.atlassian.jira.plugins.importer.external.beans.ExternalComponent;
import com.atlassian.jira.plugins.importer.external.beans.ExternalIssue;
import com.atlassian.jira.plugins.importer.external.beans.ExternalLink;
import com.atlassian.jira.plugins.importer.external.beans.ExternalProject;
import com.atlassian.jira.plugins.importer.external.beans.ExternalUser;
import com.atlassian.jira.plugins.importer.external.beans.ExternalVersion;
import com.atlassian.jira.plugins.importer.imports.importer.AbstractConfigBean2;
import com.atlassian.jira.plugins.importer.imports.importer.AbstractDataBean;
import com.atlassian.jira.plugins.importer.imports.importer.ImportLogger;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;

public class AsanaDataBean
extends AbstractDataBean<AsanaConfigBean> {
    private AsanaConfigBean configBean;
    private AsanaClient client;
    private IssueLinkTypeManager issueLinkTypeManager;

    public AsanaDataBean(AsanaConfigBean configBean, IssueLinkTypeManager issueLinkTypeManager) {
        super((AbstractConfigBean2)configBean);
        this.configBean = configBean;
        this.client = configBean.getClient();
        this.issueLinkTypeManager = issueLinkTypeManager;
    }

    public Set<ExternalUser> getRequiredUsers(Collection<ExternalProject> projects, ImportLogger importLogger) {
        return this.getAllUsers(importLogger);
    }

    public Set<ExternalUser> getAllUsers(ImportLogger log) {
        List<Workspace> workspaces = this.client.getWorkspaces(log);
        HashSet allUsers = new HashSet();
        for (Workspace workspace : workspaces) {
            Long workspaceId = workspace.getId();
            UserInWorkspaceIterator iterator = new UserInWorkspaceIterator(workspaceId, this.configBean, log);
            HashSet workspaceUsers = Sets.newHashSet((Iterator)iterator);
            allUsers.addAll(workspaceUsers);
        }
        return Sets.newHashSet((Iterable)Collections2.transform(allUsers, (Function)new UserTransformer()));
    }

    public Set<ExternalProject> getAllProjects(ImportLogger log) {
        List<Project> projects = this.client.getAllProjects(log);
        return new HashSet<ExternalProject>(Collections2.transform(projects, (Function)new ProjectTransformer(this.configBean)));
    }

    public Collection<ExternalVersion> getVersions(ExternalProject externalProject, ImportLogger importLogger) {
        return ImmutableList.of();
    }

    public Collection<ExternalComponent> getComponents(ExternalProject externalProject, ImportLogger importLogger) {
        return ImmutableList.of();
    }

    public Iterator<ExternalIssue> getIssuesIterator(ExternalProject externalProject, ImportLogger importLogger) {
        if (externalProject.getId().endsWith("-workspace")) {
            long workspaceId = Long.parseLong(externalProject.getId().split("-")[0]);
            return new ProjectlessTaskIterator(workspaceId, this.configBean, importLogger);
        }
        return new TaskIterator(Long.parseLong(externalProject.getId()), this.configBean, importLogger);
    }

    public void cleanUp() {
    }

    @Nullable
    public String getIssueKeyRegex() {
        return null;
    }

    public Collection<ExternalLink> getLinks(ImportLogger log) {
        if (this.issueLinkTypeManager.getIssueLinkTypesByName("is-subtask-of").size() == 0) {
            this.issueLinkTypeManager.createIssueLinkType("is-subtask-of", "is subtask of", "is parent of", "null");
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll(this.configBean.getIssueInMultipleProjectsHolder().getLinks());
        builder.addAll(this.configBean.getSubtaskLinks());
        return builder.build();
    }

    public long getTotalIssues(Set<ExternalProject> selectedProjects, ImportLogger log) {
        return 0L;
    }

    public String getUnusedUsersGroup() {
        return "asana-import-unused";
    }

    public Collection<ExternalAttachment> getAttachmentsForIssue(ExternalIssue externalIssue, ImportLogger log) {
        return externalIssue.getAttachments();
    }
}

