/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.asana;

import com.atlassian.jira.plugins.importer.asana.mapping.PriorityValueMappingDefinition;
import com.atlassian.jira.plugins.importer.asana.mapping.StatusValueMappingDefinition;
import com.atlassian.jira.plugins.importer.asana.rest.AsanaClient;
import com.atlassian.jira.plugins.importer.asana.rest.beans.Workspace;
import com.atlassian.jira.plugins.importer.external.beans.ExternalCustomField;
import com.atlassian.jira.plugins.importer.external.beans.ExternalIssue;
import com.atlassian.jira.plugins.importer.external.beans.ExternalLink;
import com.atlassian.jira.plugins.importer.external.beans.ExternalProject;
import com.atlassian.jira.plugins.importer.imports.config.ValueMappingDefinition;
import com.atlassian.jira.plugins.importer.imports.config.ValueMappingDefinitionsFactory;
import com.atlassian.jira.plugins.importer.imports.config.ValueMappingHelper;
import com.atlassian.jira.plugins.importer.imports.config.ValueMappingHelperImpl;
import com.atlassian.jira.plugins.importer.imports.importer.AbstractConfigBean2;
import com.atlassian.jira.util.collect.MapBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AsanaConfigBean
extends AbstractConfigBean2 {
    public static final String NOTES_EXTERNAL_FIELD = "notes";
    private AsanaClient client;
    private Collection<Workspace> selectedWorkspaces;
    private IssueInMultipleProjectsHolder issueInMultipleProjectsHolder;
    private List<ExternalLink> subtaskLinks;
    private final ExternalCustomField defaultNotesCustomField = ExternalCustomField.createFreeText((String)"notes", (String)"Notes");

    public AsanaConfigBean(AsanaClient client) {
        this.client = client;
        this.issueInMultipleProjectsHolder = new IssueInMultipleProjectsHolder();
        this.subtaskLinks = new ArrayList<ExternalLink>();
    }

    public List<String> getExternalProjectNames() {
        return this.client.getAllProjectNames(null);
    }

    public List<ExternalCustomField> getCustomFields() {
        return ImmutableList.of((Object)this.defaultNotesCustomField);
    }

    public ExternalCustomField getDefaultNotesCustomField() {
        return this.defaultNotesCustomField;
    }

    public List<String> getLinkNamesFromDb() {
        return ImmutableList.of((Object)"Subtask");
    }

    public ValueMappingHelper initializeValueMappingHelper() {
        ValueMappingDefinitionsFactory valueMappingDefinitionsFactory = new ValueMappingDefinitionsFactory(){

            public List<ValueMappingDefinition> createMappingDefinitions(ValueMappingHelper valueMappingHelper) {
                return ImmutableList.of((Object)new StatusValueMappingDefinition(AsanaConfigBean.this), (Object)new PriorityValueMappingDefinition(AsanaConfigBean.this.getConstantsManager()));
            }
        };
        return new ValueMappingHelperImpl(this.getWorkflowSchemeManager(), this.getWorkflowManager(), valueMappingDefinitionsFactory, this.getConstantsManager());
    }

    public Map<String, Map<String, String>> getAvailableFieldMappings(ExternalCustomField customField, Set<ExternalProject> projects) {
        LinkedHashMap fieldMappings = Maps.newLinkedHashMap();
        fieldMappings.put(this.getI18nHelper().getText("admin.csv.import.mappings.custom.fields.header"), this.getAvailableCustomFieldMappings(customField, projects));
        if (NOTES_EXTERNAL_FIELD.equals(customField.getId())) {
            fieldMappings.put(this.getI18nHelper().getText("admin.csv.import.mappings.issue.fields.header"), MapBuilder.newBuilder().add((Object)this.mapToIssueFieldValue("description"), (Object)this.getI18nHelper().getText("issue.field.description")).toMap());
        }
        fieldMappings.putAll(super.getAvailableFieldMappings(customField, projects));
        return fieldMappings;
    }

    public AsanaClient getClient() {
        return this.client;
    }

    public Collection<Workspace> getSelectedWorkspaces() {
        return this.selectedWorkspaces;
    }

    public void setSelectedWorkspaces(Collection<Workspace> selectedWorkspaces) {
        this.selectedWorkspaces = selectedWorkspaces;
    }

    public IssueInMultipleProjectsHolder getIssueInMultipleProjectsHolder() {
        return this.issueInMultipleProjectsHolder;
    }

    public List<ExternalLink> getSubtaskLinks() {
        return this.subtaskLinks;
    }

    protected class IssueInMultipleProjectsHolder {
        private Map<String, ExternalIssue> asanaIdToExternalIssueMap = new HashMap<String, ExternalIssue>();
        private List<ExternalLink> issuesInMultipleProjectsLinks = new ArrayList<ExternalLink>();

        protected IssueInMultipleProjectsHolder() {
        }

        public void registerIssue(Long asanaId, ExternalIssue issue) {
            ExternalIssue existingExternalIssue = this.asanaIdToExternalIssueMap.get(asanaId.toString());
            if (existingExternalIssue != null) {
                ExternalLink link = new ExternalLink("Duplicate", issue.getExternalId(), existingExternalIssue.getExternalId());
                this.issuesInMultipleProjectsLinks.add(link);
            } else {
                this.asanaIdToExternalIssueMap.put(asanaId.toString(), issue);
            }
        }

        public List<ExternalLink> getLinks() {
            return this.issuesInMultipleProjectsLinks;
        }
    }
}

