/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projecttemplates.service;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.filter.ProjectSearchRequestService;
import com.atlassian.jira.bc.filter.SearchRequestService;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.config.PriorityManager;
import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.issue.IssueConstant;
import com.atlassian.jira.issue.priority.Priority;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectCreateHandler;
import com.atlassian.jira.project.ProjectCreatedData;
import com.atlassian.jira.project.template.ProjectTemplateKey;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.sharing.SharePermission;
import com.atlassian.jira.sharing.SharePermissionImpl;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.sharing.type.ShareType;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BusinessProjectSearchRequestGeneratorHandler
implements ProjectCreateHandler {
    private static final Logger log = LoggerFactory.getLogger(BusinessProjectSearchRequestGeneratorHandler.class);
    private static final String TEMPLATE_PREFIX = "com.atlassian.jira-core-project-templates:";
    private static final Map<ProjectTemplateKey, List<Filter>> TEMPLATE_FILTERS = Maps.newHashMap();
    private final JiraAuthenticationContext authenticationContext;
    private final SearchService searchService;
    private final SearchRequestService searchRequestService;
    private final ProjectSearchRequestService projectSearchRequestService;
    private final PriorityManager priorityManager;

    public BusinessProjectSearchRequestGeneratorHandler(JiraAuthenticationContext authenticationContext, SearchService searchService, SearchRequestService searchRequestService, ProjectSearchRequestService projectSearchRequestService, PriorityManager priorityManager) {
        this.authenticationContext = authenticationContext;
        this.searchService = searchService;
        this.searchRequestService = searchRequestService;
        this.projectSearchRequestService = projectSearchRequestService;
        this.priorityManager = priorityManager;
    }

    public String getHandlerId() {
        return "com.atlassian.jira.project-templates-plugin:business-project-search-request-generator-handler";
    }

    public void onProjectCreated(ProjectCreatedData projectCreatedData) throws CreateException {
        Optional templateKey = projectCreatedData.getProjectTemplateKey();
        templateKey.ifPresent(template -> {
            Project project = projectCreatedData.getProject();
            ApplicationUser user = this.authenticationContext.getLoggedInUser();
            Optional topPriority = this.priorityManager.getPriorities().stream().findFirst();
            ArrayList createdFilterIds = Lists.newArrayList();
            List<Filter> filters = TEMPLATE_FILTERS.getOrDefault(template, Collections.emptyList());
            filters.forEach(filter -> {
                Optional<SearchRequest> searchRequest = this.initSearchRequestData(user, project, topPriority, (Filter)filter);
                searchRequest.flatMap(request -> this.persistSearchRequest(user, project, (SearchRequest)request)).ifPresent(newRequest -> createdFilterIds.add(newRequest.getId()));
            });
            this.projectSearchRequestService.associateSearchRequestsWithProject(user, project, createdFilterIds.toArray(new Long[createdFilterIds.size()]));
        });
    }

    public void onProjectCreationRolledBack(ProjectCreatedData projectCreatedData) {
        ApplicationUser user = this.authenticationContext.getLoggedInUser();
        List filters = this.projectSearchRequestService.getSearchRequestsForProject(user, projectCreatedData.getProject());
        filters.forEach(filter -> {
            JiraServiceContextImpl context = new JiraServiceContextImpl(user);
            this.searchRequestService.deleteFilter((JiraServiceContext)context, filter.getId());
        });
    }

    private Optional<SearchRequest> persistSearchRequest(ApplicationUser user, Project project, SearchRequest request) {
        JiraServiceContextImpl context = new JiraServiceContextImpl(user);
        this.searchRequestService.validateFilterForCreate((JiraServiceContext)context, request);
        if (!context.getErrorCollection().hasAnyErrors()) {
            SearchRequest newRequest = this.searchRequestService.createFilter((JiraServiceContext)context, request);
            if (context.getErrorCollection().hasAnyErrors()) {
                this.logWarnings(project, context.getErrorCollection().getErrorMessages());
            }
            return Optional.ofNullable(newRequest);
        }
        this.logWarnings(project, context.getErrorCollection().getErrorMessages());
        return Optional.empty();
    }

    private Optional<SearchRequest> initSearchRequestData(ApplicationUser user, Project project, Optional<Priority> topPriority, Filter filter) {
        SearchService.ParseResult parseResult = this.searchService.parseQuery(user, filter.getJql(project, topPriority));
        if (!parseResult.isValid()) {
            this.logWarnings(project, parseResult.getErrors().getErrorMessages());
            return Optional.empty();
        }
        SearchRequest request = new SearchRequest(parseResult.getQuery());
        request.setName(filter.getName(this.authenticationContext.getI18nHelper(), project));
        request.setOwner(user);
        request.setPermissions(this.getProjectSharePermission(project));
        return Optional.of(request);
    }

    private SharedEntity.SharePermissions getProjectSharePermission(Project project) {
        HashSet shares = Sets.newHashSet((Object[])new SharePermission[]{new SharePermissionImpl(ShareType.Name.PROJECT, Long.toString(project.getId()), null)});
        return new SharedEntity.SharePermissions((Set)shares);
    }

    private void logWarnings(Project project, Iterable<String> errors) {
        if (log.isWarnEnabled()) {
            log.warn("Unable to create filters for project '{0}':", (Object)project.getName());
            errors.forEach(arg_0 -> ((Logger)log).warn(arg_0));
        }
    }

    static {
        TEMPLATE_FILTERS.put(new ProjectTemplateKey("com.atlassian.jira-core-project-templates:jira-core-task-management"), Lists.newArrayList((Object[])new Filter[]{new Filter("core.project.template.project.filter.task.highest.priority.open", "project = %s and statusCategory != Done and priority = %s ORDER BY duedate desc, priority desc"), new Filter("core.project.template.project.filter.task.due.this.week", "project = %s and duedate >= startOfWeek() and duedate <= endOfWeek() ORDER BY priority desc")}));
        TEMPLATE_FILTERS.put(new ProjectTemplateKey("com.atlassian.jira-core-project-templates:jira-core-project-management"), Lists.newArrayList((Object[])new Filter[]{new Filter("core.project.template.project.filter.project.open.unassigned", "project = %s and statusCategory != Done and assignee = EMPTY ORDER BY priority desc"), new Filter("core.project.template.project.filter.project.due.this.week", "project = %s and duedate >= startOfWeek() and duedate <= endOfWeek() ORDER BY priority desc"), new Filter("core.project.template.project.filter.project.overdue", "project = %s and statusCategory != Done and duedate < now() ORDER BY duedate desc")}));
        TEMPLATE_FILTERS.put(new ProjectTemplateKey("com.atlassian.jira-core-project-templates:jira-core-process-management"), Lists.newArrayList((Object[])new Filter[]{new Filter("core.project.template.project.filter.process.ready.review", "project = %s and status = \"Under Review\" ORDER BY priority desc"), new Filter("core.project.template.project.filter.process.approved", "project = %s and status = \"Approved\" ORDER BY updated desc"), new Filter("core.project.template.project.filter.process.rejected", "project = %s and status = \"Rejected\" ORDER BY updated desc")}));
    }

    private static class Filter {
        private final String nameI18nKey;
        private final String jql;

        public Filter(String nameI18nKey, String jql) {
            this.nameI18nKey = nameI18nKey;
            this.jql = jql;
        }

        public String getName(I18nHelper i18n, Project project) {
            return i18n.getText(this.nameI18nKey, project.getKey());
        }

        public String getJql(Project project, Optional<Priority> topPriority) {
            return String.format(this.jql, project.getId(), topPriority.map(IssueConstant::getId).orElse("EMPTY"));
        }
    }
}

