/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.mail.webwork;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.mail.server.MailServer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import org.apache.log4j.Logger;

abstract class VerifyMailServer {
    protected final Collection<String> errors = new ArrayList<String>();
    protected static final Logger log = Logger.getLogger(VerifyMailServer.class);

    VerifyMailServer() {
    }

    public boolean hasErrors() {
        return this.errors.size() > 0;
    }

    public Collection<String> getErrorMessages() {
        return this.errors;
    }

    protected I18nHelper getI18nHelper() {
        return ComponentAccessor.getJiraAuthenticationContext().getI18nHelper();
    }

    public abstract void verifyMailServer(MailServer var1);

    protected void addTimeouts(MailServer server, long verifyTimeout) {
        Properties p = server.getProperties();
        String protocol = p.getProperty("mail.transport.protocol");
        String connectionTimeout = String.format("mail.%s.connectiontimeout", protocol);
        String socketTimeout = String.format("mail.%s.timeout", protocol);
        p.setProperty(connectionTimeout, "" + verifyTimeout);
        p.setProperty(socketTimeout, "" + verifyTimeout);
    }
}

