/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.mail.webwork;

import com.atlassian.configurable.ObjectConfigurationException;
import com.atlassian.jira.plugins.mail.webwork.AbstractEditHandlerDetailsWebAction;
import com.atlassian.jira.service.JiraServiceContainer;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.opensymphony.util.TextUtils;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

@WebSudoRequired
public class EditHandlerDetailsUsingParamsWebAction
extends AbstractEditHandlerDetailsWebAction {
    private String forwardEmail;
    private String params;

    public EditHandlerDetailsUsingParamsWebAction(PluginAccessor pluginAccessor) {
        super(pluginAccessor);
    }

    protected void doValidation() {
        if (this.configuration == null) {
            return;
        }
        super.doValidation();
        if (StringUtils.isNotBlank((String)this.getForwardEmail()) && !TextUtils.verifyEmail((String)TextUtils.noNull((String)this.getForwardEmail()).trim())) {
            this.addError("forwardEmail", this.getText("admin.errors.invalid.email"));
        }
    }

    @Override
    protected void copyServiceSettings(JiraServiceContainer serviceContainer) throws ObjectConfigurationException {
        this.forwardEmail = serviceContainer.getProperty("forwardEmail");
        this.params = serviceContainer.getProperty("handler.params");
    }

    @Override
    protected Map<String, String[]> getAdditionalServiceParams() throws Exception {
        return MapBuilder.newBuilder((Object)"forwardEmail", (Object)new String[]{this.getForwardEmail()}).toMutableMap();
    }

    @Override
    protected Map<String, String[]> getServiceParams() throws Exception {
        Map<String, String[]> serviceParams = super.getServiceParams();
        serviceParams.put("handler.params", new String[]{this.getParams()});
        return serviceParams;
    }

    public String getForwardEmail() {
        return this.forwardEmail;
    }

    public void setForwardEmail(String forwardEmail) {
        this.forwardEmail = forwardEmail;
    }

    @Override
    protected Map<String, String> getHandlerParams() {
        return Collections.emptyMap();
    }

    public String getParams() {
        return this.params;
    }

    public void setParams(String params) {
        this.params = params;
    }
}

