/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.mail.webwork;

import com.atlassian.jira.plugins.mail.webwork.MailWebActionSupport;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.service.JiraServiceContainer;
import com.atlassian.jira.service.ServiceManager;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import javax.annotation.Nullable;

@WebSudoRequired
public class DeleteMailHandler
extends MailWebActionSupport {
    private final ServiceManager serviceManager;
    private Long id;
    private boolean confirmed;

    public DeleteMailHandler(ServiceManager serviceManager) {
        this.serviceManager = serviceManager;
    }

    protected void doValidation() {
        if (this.getId() == null || !this.isConfirmed()) {
            this.addErrorMessage(this.getText("admin.errors.mail.confirm.deletion.of.server"));
        }
    }

    public boolean isConfirmed() {
        return this.confirmed;
    }

    public void setConfirmed(boolean confirmed) {
        this.confirmed = confirmed;
    }

    @RequiresXsrfCheck
    public String doExecute() throws Exception {
        if (!this.canDeleteService(this.id)) {
            return "securitybreach";
        }
        this.log.debug((Object)("Removing Service with id " + this.id));
        this.serviceManager.removeService(this.id);
        return this.getRedirect("IncomingMailServers.jspa");
    }

    private boolean canDeleteService(final Long serviceId) throws Exception {
        return Iterables.any((Iterable)this.serviceManager.getServicesManageableBy(this.getLoggedInApplicationUser()), (Predicate)new Predicate<JiraServiceContainer>(){

            public boolean apply(@Nullable JiraServiceContainer aServiceManageableByTheUser) {
                return serviceId.equals(aServiceManageableByTheUser.getId());
            }
        });
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCancelURI() {
        return "IncomingMailServers.jspa";
    }

    public String getName() {
        try {
            JiraServiceContainer service = this.serviceManager.getServiceWithId(this.id);
            return service != null ? service.getName() : "";
        }
        catch (Exception e) {
            return "";
        }
    }
}

