/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.mail.rest;

import com.atlassian.configurable.ObjectConfigurationException;
import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.plugin.ComponentClassManager;
import com.atlassian.jira.plugins.mail.DryRunMessageHandlerExecutionMonitor;
import com.atlassian.jira.plugins.mail.HandlerDetailsValidator;
import com.atlassian.jira.plugins.mail.ServiceConfiguration;
import com.atlassian.jira.plugins.mail.handlers.DryRunMessageHandlerContext;
import com.atlassian.jira.plugins.mail.model.ErrorModel;
import com.atlassian.jira.plugins.mail.model.HandlerDetailsModel;
import com.atlassian.jira.plugins.mail.model.TestResultModel;
import com.atlassian.jira.plugins.mail.model.ValidationResultModel;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.xsrf.XsrfCheckResult;
import com.atlassian.jira.security.xsrf.XsrfInvocationChecker;
import com.atlassian.jira.service.services.file.AbstractMessageHandlingService;
import com.atlassian.jira.service.util.ServiceUtils;
import com.atlassian.jira.service.util.handler.MessageHandlerContext;
import com.atlassian.jira.service.util.handler.MessageHandlerStats;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.util.ContextClassLoaderSwitchingUtil;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.module.propertyset.map.MapPropertySet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.codehaus.jackson.map.ObjectMapper;

@Path(value="/message-handlers")
public class MessageHandlersResource {
    protected static final Logger logger = Logger.getLogger(MessageHandlersResource.class);
    private final JiraAuthenticationContext authenticationContext;
    private final GlobalPermissionManager globalPermissionManager;
    private final HandlerDetailsValidator detailsValidator;
    private final PluginAccessor pluginAccessor;
    private final XsrfInvocationChecker xsrfChecker;
    private final I18nHelper i18n;

    public MessageHandlersResource(JiraAuthenticationContext authenticationContext, GlobalPermissionManager globalPermissionManager, HandlerDetailsValidator detailsValidator, PluginAccessor pluginAccessor, XsrfInvocationChecker xsrfChecker, I18nHelper i18n) {
        this.authenticationContext = authenticationContext;
        this.globalPermissionManager = globalPermissionManager;
        this.detailsValidator = detailsValidator;
        this.pluginAccessor = pluginAccessor;
        this.xsrfChecker = xsrfChecker;
        this.i18n = i18n;
    }

    protected boolean isAdministrator() {
        ApplicationUser currentUser = this.authenticationContext.getLoggedInUser();
        return currentUser != null && this.globalPermissionManager.hasPermission(0, currentUser);
    }

    @POST
    @Path(value="/validate")
    @Produces(value={"application/json"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response validate(@Context HttpServletRequest req, @FormParam(value="detailsJson") String detailsJson) {
        XsrfCheckResult xsrfCheckResult = this.xsrfChecker.checkWebRequestInvocation(req);
        if (xsrfCheckResult.isRequired() && !xsrfCheckResult.isValid()) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)ErrorModel.of(this.i18n.getText("xsrf.error.title"))).build();
        }
        if (!this.isAdministrator()) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        ServiceConfiguration configuration = this.getConfiguration(req);
        if (configuration == null) {
            return Response.status((Response.Status)Response.Status.GONE).build();
        }
        try {
            HandlerDetailsModel details = (HandlerDetailsModel)new ObjectMapper().readValue(detailsJson, HandlerDetailsModel.class);
            ErrorCollection validation = this.detailsValidator.validateDetails(details);
            return Response.ok((Object)new ValidationResultModel(validation)).build();
        }
        catch (Exception e) {
            logger.error((Object)"Unable to validate", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @POST
    @Path(value="/test")
    @Produces(value={"application/json"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response testHandler(@Context HttpServletRequest req, @FormParam(value="detailsJson") String detailsJson) {
        XsrfCheckResult xsrfCheckResult = this.xsrfChecker.checkWebRequestInvocation(req);
        if (xsrfCheckResult.isRequired() && !xsrfCheckResult.isValid()) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)ErrorModel.of(this.i18n.getText("xsrf.error.title"))).build();
        }
        if (!this.isAdministrator()) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        ServiceConfiguration configuration = this.getConfiguration(req);
        if (configuration == null) {
            return Response.status((Response.Status)Response.Status.GONE).build();
        }
        try {
            final AbstractMessageHandlingService service = (AbstractMessageHandlingService)this.getComponentClassManager().newInstance(configuration.getServiceClass());
            if (service != null) {
                HashMap serviceParams = Maps.newHashMap(configuration.toMap(this.pluginAccessor));
                HandlerDetailsModel details = (HandlerDetailsModel)new ObjectMapper().readValue(detailsJson, HandlerDetailsModel.class);
                ErrorCollection validation = this.detailsValidator.validateDetails(details);
                if (validation.hasAnyErrors()) {
                    return Response.ok((Object)new ValidationResultModel(validation)).build();
                }
                if (StringUtils.isNotBlank((String)details.getForwardEmail())) {
                    serviceParams.put("forwardEmail", details.getForwardEmail());
                }
                serviceParams.put("handler.params", ServiceUtils.toParameterString(details.toServiceParams()));
                final MapPropertySet set = new MapPropertySet();
                set.setMap((Map)serviceParams);
                DryRunMessageHandlerExecutionMonitor executionMonitor = new DryRunMessageHandlerExecutionMonitor();
                final DryRunMessageHandlerContext context = new DryRunMessageHandlerContext(executionMonitor);
                ContextClassLoaderSwitchingUtil.runInContext((ClassLoader)service.getClass().getClassLoader(), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        service.setContext((MessageHandlerContext)context);
                        try {
                            service.init((PropertySet)set);
                        }
                        catch (ObjectConfigurationException e) {
                            throw new RuntimeException(e);
                        }
                        service.run();
                    }
                });
                return Response.ok((Object)new TestResultModel(!executionMonitor.hasErrors(), (Collection<String>)ImmutableList.copyOf(executionMonitor.getErrorMessages()), new MessageHandlerStats(executionMonitor.getNumMessages(), context.getNumCreatedIssues(), context.getNumCreatedUsers(), context.getNumCreatedComments(), context.getNumCreatedAttachments(), executionMonitor.getNumMessagesRejected()), executionMonitor.getAllMessages())).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Exception e) {
            logger.error((Object)"Unable to execute test", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @Nullable
    private ServiceConfiguration getConfiguration(HttpServletRequest req) {
        HttpSession session = req.getSession(false);
        if (session != null) {
            try {
                return (ServiceConfiguration)session.getAttribute(ServiceConfiguration.ID);
            }
            catch (ClassCastException e) {
                return null;
            }
        }
        return null;
    }

    @Nonnull
    protected ComponentClassManager getComponentClassManager() {
        return (ComponentClassManager)ComponentManager.getComponentInstanceOfType(ComponentClassManager.class);
    }
}

