/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.mail.handlers;

import com.atlassian.jira.JiraApplicationContext;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.util.IssueUpdater;
import com.atlassian.jira.mail.MailLoggingManager;
import com.atlassian.jira.plugins.mail.handlers.AbstractCommentHandler;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.service.util.handler.MessageHandlerErrorCollector;
import com.atlassian.jira.service.util.handler.MessageUserProcessor;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.mail.MailUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Part;
import org.apache.commons.lang.StringUtils;
import org.apache.oro.text.perl.MalformedPerl5PatternException;
import org.apache.oro.text.perl.Perl5Util;

public class RegexCommentHandler
extends AbstractCommentHandler {
    public static final String KEY_SPLITREGEX = "splitregex";
    private String splitRegex;

    public RegexCommentHandler() {
    }

    protected RegexCommentHandler(PermissionManager permissionManager, IssueUpdater issueUpdater, UserManager userManager, ApplicationProperties applicationProperties, JiraApplicationContext jiraApplicationContext, MailLoggingManager mailLoggingManager, MessageUserProcessor messageUserProcessor) {
        super(permissionManager, issueUpdater, userManager, applicationProperties, jiraApplicationContext, mailLoggingManager, messageUserProcessor);
    }

    @Override
    public void init(Map<String, String> params, MessageHandlerErrorCollector errorCollector) {
        super.init(params, errorCollector);
        if (params.containsKey(KEY_SPLITREGEX)) {
            this.setSplitRegex(params.get(KEY_SPLITREGEX));
        }
    }

    @Override
    protected String getEmailBody(Message message) throws MessagingException {
        return this.splitMailBody(MailUtils.getBody((Message)message));
    }

    public String splitMailBody(String rawBody) {
        String splitRegex = this.getSplitRegex();
        try {
            if (StringUtils.isNotEmpty((String)splitRegex)) {
                ArrayList parts = new ArrayList();
                new Perl5Util().split(parts, splitRegex, rawBody);
                if (parts.isEmpty()) {
                    this.log.debug((Object)("Regex " + splitRegex + " did not match any text in email; using full text for comment."));
                } else if (parts.size() > 1) {
                    this.log.debug((Object)("Regex " + splitRegex + " matched " + parts.size() + " times; using first as comment."));
                    StringBuilder comment = new StringBuilder("\n");
                    comment.append(((String)parts.get(0)).trim());
                    comment.append("\n\n");
                    return comment.toString();
                }
            }
        }
        catch (MalformedPerl5PatternException pe) {
            this.log.error((Object)("Invalid regex in parameter splitregex=" + splitRegex + " on regex comment handler. Note that regex must be in the format /foo/, and cannot contain commas (as they are used for separating handler params). " + (Object)((Object)pe)), (Throwable)pe);
        }
        catch (RuntimeException e) {
            this.log.warn((Object)"Failed to split email body. Appending raw content...", (Throwable)e);
        }
        return rawBody;
    }

    public String getSplitRegex() {
        return this.splitRegex;
    }

    public void setSplitRegex(String splitRegex) {
        this.splitRegex = splitRegex;
    }

    @Override
    protected boolean attachPlainTextParts(Part part) throws MessagingException, IOException {
        return !MailUtils.isContentEmpty((Part)part);
    }

    @Override
    protected boolean attachHtmlParts(Part part) throws MessagingException, IOException {
        return false;
    }
}

