/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.mail.handlers;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.impl.ImmutableUser;
import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.exception.PermissionException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.service.util.handler.MessageHandlerContext;
import com.atlassian.jira.service.util.handler.MessageHandlerExecutionMonitor;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import com.atlassian.jira.user.DelegatingApplicationUser;
import com.atlassian.jira.web.util.AttachmentException;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;

public class DryRunMessageHandlerContext
implements MessageHandlerContext {
    private final Map<String, ApplicationUser> dummyUsersById = Maps.newHashMap();
    private final MessageHandlerExecutionMonitor messageHandlerExecutionMonitor;
    private int numCreatedIssues;
    private int numCreatedComments;
    private int numCreatedUsers;
    private int numCreatedAttachments;

    public DryRunMessageHandlerContext(MessageHandlerExecutionMonitor messageHandlerExecutionMonitor) {
        this.messageHandlerExecutionMonitor = messageHandlerExecutionMonitor;
    }

    public ApplicationUser createUser(String username, String password, String emailAddress, String displayName, Integer userEventType) throws PermissionException, CreateException {
        ApplicationUser user = this.dummyUsersById.get(username);
        if (user == null) {
            this.messageHandlerExecutionMonitor.info("Creating user '" + username + "'.");
            ++this.numCreatedUsers;
            user = new DelegatingApplicationUser(Long.valueOf(-1L), username, (User)new ImmutableUser(-1L, username, displayName, emailAddress, true));
            this.dummyUsersById.put(username, user);
        }
        return user;
    }

    public boolean isRealRun() {
        return false;
    }

    public Comment createComment(final Issue issue, final ApplicationUser author, final String body, boolean dispatchEvent) {
        this.messageHandlerExecutionMonitor.info("Adding comment '" + StringUtils.abbreviate((String)body, (int)20) + "' by user '" + author.getName() + "' to issue '" + issue.getKey() + "'.");
        final DateTime now = new DateTime();
        ++this.numCreatedComments;
        return new Comment(){

            public String getAuthor() {
                return author.getName();
            }

            public String getAuthorKey() {
                return ApplicationUsers.getKeyFor((ApplicationUser)author);
            }

            public ApplicationUser getAuthorUser() {
                return author;
            }

            public ApplicationUser getAuthorApplicationUser() {
                return author;
            }

            public String getAuthorFullName() {
                return author.getDisplayName();
            }

            public String getBody() {
                return body;
            }

            public Date getCreated() {
                return now.toDate();
            }

            public String getGroupLevel() {
                return null;
            }

            public Long getId() {
                return null;
            }

            public Long getRoleLevelId() {
                return null;
            }

            public ProjectRole getRoleLevel() {
                return null;
            }

            public Issue getIssue() {
                return issue;
            }

            public String getUpdateAuthor() {
                return author.getName();
            }

            public ApplicationUser getUpdateAuthorUser() {
                return author;
            }

            public ApplicationUser getUpdateAuthorApplicationUser() {
                throw new UnsupportedOperationException("Not implemented");
            }

            public String getUpdateAuthorFullName() {
                return author.getDisplayName();
            }

            public Date getUpdated() {
                return now.toDate();
            }
        };
    }

    public Issue createIssue(ApplicationUser reporter, Issue issue) throws CreateException {
        this.getMonitor().info("Creating issue with summary '" + issue.getSummary() + "' and reporter '" + issue.getReporterId() + "'");
        ++this.numCreatedIssues;
        return issue;
    }

    public ChangeItemBean createAttachment(File file, String filename, String contentType, ApplicationUser author, Issue issue) throws AttachmentException {
        this.getMonitor().info("Creating attachment '" + filename + "'");
        ++this.numCreatedAttachments;
        return new ChangeItemBean();
    }

    public MessageHandlerExecutionMonitor getMonitor() {
        return this.messageHandlerExecutionMonitor;
    }

    public int getNumCreatedIssues() {
        return this.numCreatedIssues;
    }

    public int getNumCreatedComments() {
        return this.numCreatedComments;
    }

    public int getNumCreatedUsers() {
        return this.numCreatedUsers;
    }

    public int getNumCreatedAttachments() {
        return this.numCreatedAttachments;
    }
}

