/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.mail.handlers;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.plugins.mail.handlers.AbstractMessageHandler;
import com.atlassian.jira.plugins.mail.handlers.CreateIssueHandler;
import com.atlassian.jira.plugins.mail.handlers.FullCommentHandler;
import com.atlassian.jira.plugins.mail.handlers.NonQuotedCommentHandler;
import com.atlassian.jira.service.util.ServiceUtils;
import com.atlassian.jira.service.util.handler.MessageHandlerContext;
import com.atlassian.jira.service.util.handler.MessageHandlerErrorCollector;
import com.atlassian.jira.service.util.handler.MessageUserProcessor;
import com.atlassian.mail.MailUtils;
import java.io.IOException;
import java.util.Map;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Part;

public class CreateOrCommentHandler
extends AbstractMessageHandler {
    public String projectKey;
    public String issueType;
    public String stripquotes;
    public static final String KEY_PROJECT = "project";
    public static final String KEY_ISSUETYPE = "issuetype";
    public static final String KEY_QUOTES = "stripquotes";
    private static final String FALSE = "false";

    @Override
    public boolean handleMessage(Message message, MessageHandlerContext context) throws MessagingException {
        Issue issue;
        String subject = message.getSubject();
        if (!this.canHandleMessage(message, context.getMonitor())) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Cannot handle message '" + subject + "'."));
            }
            return this.deleteEmail;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Looking for Issue Key in subject '" + subject + "'."));
        }
        if ((issue = ServiceUtils.findIssueObjectInString((String)subject)) == null) {
            this.log.debug((Object)("Issue Key not found in subject '" + subject + "'. Inspecting the in-reply-to message ID."));
            issue = this.getAssociatedIssue(message);
        }
        if (issue != null) {
            boolean doDelete;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Issue '" + issue.getKey() + "' found for email '" + subject + "'."));
            }
            if (this.stripquotes == null || FALSE.equalsIgnoreCase(this.stripquotes)) {
                FullCommentHandler fc = new FullCommentHandler(){

                    @Override
                    protected MessageUserProcessor getMessageUserProcessor() {
                        return CreateOrCommentHandler.this.getMessageUserProcessor();
                    }
                };
                fc.init(this.params, (MessageHandlerErrorCollector)context.getMonitor());
                doDelete = fc.handleMessage(message, context);
            } else {
                NonQuotedCommentHandler nq = new NonQuotedCommentHandler(){

                    @Override
                    protected MessageUserProcessor getMessageUserProcessor() {
                        return CreateOrCommentHandler.this.getMessageUserProcessor();
                    }
                };
                nq.init(this.params, (MessageHandlerErrorCollector)context.getMonitor());
                doDelete = nq.handleMessage(message, context);
            }
            return doDelete;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("No Issue found for email '" + subject + "' - creating a new Issue."));
        }
        CreateIssueHandler createIssueHandler = new CreateIssueHandler(){

            @Override
            protected MessageUserProcessor getMessageUserProcessor() {
                return CreateOrCommentHandler.this.getMessageUserProcessor();
            }
        };
        createIssueHandler.init(this.params, (MessageHandlerErrorCollector)context.getMonitor());
        return createIssueHandler.handleMessage(message, context);
    }

    @Override
    public void init(Map<String, String> params, MessageHandlerErrorCollector errorCollector) {
        this.log.debug((Object)("CreateOrCommentHandler.init(params: " + params + ")"));
        super.init(params, errorCollector);
        if (params.containsKey(KEY_PROJECT)) {
            this.projectKey = params.get(KEY_PROJECT);
        }
        if (params.containsKey(KEY_ISSUETYPE)) {
            this.issueType = params.get(KEY_ISSUETYPE);
        }
        if (params.containsKey(KEY_QUOTES)) {
            this.stripquotes = params.get(KEY_QUOTES);
        }
    }

    @Override
    protected boolean attachPlainTextParts(Part part) throws MessagingException, IOException {
        return !MailUtils.isContentEmpty((Part)part);
    }

    @Override
    protected boolean attachHtmlParts(Part part) throws MessagingException, IOException {
        return false;
    }
}

