/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.mail.handlers;

import com.atlassian.annotations.PublicSpi;
import com.atlassian.core.util.collection.EasyList;
import com.atlassian.jira.JiraApplicationContext;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.event.mau.MauEventService;
import com.atlassian.jira.exception.ParseException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.mail.MailLoggingManager;
import com.atlassian.jira.mail.MailThreadManager;
import com.atlassian.jira.plugins.mail.handlers.GeneratedAttachmentRecogniser;
import com.atlassian.jira.plugins.mail.internal.MailLoopDetectionService;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.service.util.handler.MessageHandler;
import com.atlassian.jira.service.util.handler.MessageHandlerContext;
import com.atlassian.jira.service.util.handler.MessageHandlerErrorCollector;
import com.atlassian.jira.service.util.handler.MessageHandlerExecutionMonitor;
import com.atlassian.jira.service.util.handler.MessageUserProcessor;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserKeyService;
import com.atlassian.jira.user.UserUtils;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.util.FileNameCharacterCheckerUtil;
import com.atlassian.mail.MailUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.opensymphony.util.TextUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Flags;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.internet.InternetAddress;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

@Deprecated
@PublicSpi
public abstract class AbstractMessageHandler
implements MessageHandler {
    protected final Logger log;
    @Deprecated
    public static final String KEY_REPORTER = "reporterusername";
    public static final String KEY_REPORTER_KEY = "reporteruserkey";
    public static final String KEY_CATCHEMAIL = "catchemail";
    public static final String KEY_CREATEUSERS = "createusers";
    public static final String KEY_NOTIFYUSERS = "notifyusers";
    public static final String KEY_FINGER_PRINT = "fingerprint";
    public static final String VALUE_FINGER_PRINT_ACCEPT = "accept";
    public static final String VALUE_FINGER_PRINT_FORWARD = "forward";
    public static final String VALUE_FINGER_PRINT_IGNORE = "ignore";
    private final List VALUES_FINGERPRINT = EasyList.build((Object)"accept", (Object)"forward", (Object)"ignore");
    public static final String KEY_BULK = "bulk";
    public static final String VALUE_BULK_ACCEPT = "accept";
    public static final String VALUE_BULK_IGNORE = "ignore";
    public static final String VALUE_BULK_FORWARD = "forward";
    public static final String VALUE_BULK_DELETE = "delete";
    protected static final String CONTENT_TYPE_TEXT = "text/plain";
    protected static final String HEADER_MESSAGE_ID = "message-id";
    protected static final String HEADER_IN_REPLY_TO = "in-reply-to";
    private static final String ATTACHED_MESSAGE_FILENAME = "attachedmessage";
    private static final String DEFAULT_BINARY_FILE_NAME = "binary.bin";
    protected boolean deleteEmail;
    protected Map<String, String> params = new HashMap<String, String>();
    public String reporteruserName;
    public String reporterUserKey;
    public String catchEmail;
    public String bulk;
    public boolean createUsers;
    public boolean notifyUsers;
    private String fingerPrintPolicy;
    protected final UserManager userManager;
    protected final MessageUserProcessor messageUserProcessor;
    protected final ApplicationProperties applicationProperties;
    protected final PermissionManager permissionManager;
    protected MauEventService mauEventService;
    private final JiraApplicationContext jiraApplicationContext;
    private final UserKeyService userKeyService;
    private static final FileNameCharacterCheckerUtil fileNameCharacterCheckerUtil = new FileNameCharacterCheckerUtil();
    private static final char INVALID_CHAR_REPLACEMENT = '_';

    @Deprecated
    protected AbstractMessageHandler() {
        this(ComponentAccessor.getUserManager(), ComponentAccessor.getApplicationProperties(), (JiraApplicationContext)ComponentAccessor.getComponent(JiraApplicationContext.class), (MailLoggingManager)ComponentAccessor.getComponent(MailLoggingManager.class), (MessageUserProcessor)ComponentAccessor.getComponent(MessageUserProcessor.class));
    }

    protected AbstractMessageHandler(ApplicationProperties applicationProperties, JiraApplicationContext jiraApplicationContext) {
        this(ComponentAccessor.getUserManager(), applicationProperties, jiraApplicationContext, (MailLoggingManager)ComponentAccessor.getComponent(MailLoggingManager.class), (MessageUserProcessor)ComponentAccessor.getComponent(MessageUserProcessor.class));
    }

    protected AbstractMessageHandler(UserManager userManager, ApplicationProperties applicationProperties, JiraApplicationContext jiraApplicationContext, MailLoggingManager mailLoggingManager, MessageUserProcessor messageUserProcessor) {
        this(userManager, applicationProperties, jiraApplicationContext, mailLoggingManager, messageUserProcessor, ComponentAccessor.getPermissionManager(), ComponentAccessor.getUserKeyService(), (MauEventService)ComponentAccessor.getComponent(MauEventService.class));
    }

    protected AbstractMessageHandler(UserManager userManager, ApplicationProperties applicationProperties, JiraApplicationContext jiraApplicationContext, MailLoggingManager mailLoggingManager, MessageUserProcessor messageUserProcessor, PermissionManager permissionManager) {
        this(userManager, applicationProperties, jiraApplicationContext, mailLoggingManager, messageUserProcessor, permissionManager, ComponentAccessor.getUserKeyService(), (MauEventService)ComponentAccessor.getComponent(MauEventService.class));
    }

    protected AbstractMessageHandler(UserManager userManager, ApplicationProperties applicationProperties, JiraApplicationContext jiraApplicationContext, MailLoggingManager mailLoggingManager, MessageUserProcessor messageUserProcessor, PermissionManager permissionManager, UserKeyService userKeyService, MauEventService mauEventService) {
        this.userManager = userManager;
        this.applicationProperties = applicationProperties;
        this.jiraApplicationContext = jiraApplicationContext;
        this.userKeyService = userKeyService;
        this.log = mailLoggingManager.getIncomingMailChildLogger(ClassUtils.getShortClassName(this.getClass()));
        com.atlassian.plugin.util.Assertions.notNull((String)"messageUserProcessor", (Object)messageUserProcessor);
        this.messageUserProcessor = messageUserProcessor;
        this.permissionManager = permissionManager;
        this.mauEventService = mauEventService;
    }

    public void init(Map<String, String> params, MessageHandlerErrorCollector errorCollector) {
        this.params = params;
        if (params.containsKey(KEY_REPORTER)) {
            this.reporteruserName = params.get(KEY_REPORTER);
            this.reporterUserKey = this.userKeyService.getKeyForUsername(this.reporteruserName);
        }
        if (params.containsKey(KEY_REPORTER_KEY)) {
            this.reporterUserKey = params.get(KEY_REPORTER_KEY);
            this.reporteruserName = this.userKeyService.getUsernameForKey(this.reporterUserKey);
        }
        if (params.containsKey(KEY_CATCHEMAIL)) {
            this.catchEmail = params.get(KEY_CATCHEMAIL);
        }
        if (params.containsKey(KEY_BULK)) {
            this.bulk = params.get(KEY_BULK);
        }
        if (params.containsKey(KEY_CREATEUSERS)) {
            this.createUsers = Boolean.valueOf(params.get(KEY_CREATEUSERS));
            if (this.createUsers) {
                if (this.reporteruserName != null) {
                    if (this.userManager.hasWritableDirectory()) {
                        errorCollector.warning("Default Reporter Username set to '" + this.reporteruserName + "' and " + KEY_CREATEUSERS + " is set to true.");
                        errorCollector.warning("Ignoring the Default Reporter Username, users will be created if they do not exist.");
                    } else {
                        errorCollector.warning("Default Reporter Username set to '" + this.reporteruserName + "', " + KEY_CREATEUSERS + " is set to true and no user directories are writable.");
                        errorCollector.warning("Ignoring the createusers flag. Using the default Reporter username '" + this.reporteruserName + "'.");
                    }
                } else if (!this.userManager.hasWritableDirectory()) {
                    errorCollector.warning("createusers is set to true, but no user directories are writable.  Users will NOT be created.");
                }
            }
            this.notifyUsers = !params.containsKey(KEY_NOTIFYUSERS) || Boolean.parseBoolean(params.get(KEY_NOTIFYUSERS));
        } else {
            this.log.debug((Object)"Defaulting to not creating users");
            this.createUsers = false;
            this.log.debug((Object)"Defaulting to notifying users since user creation is not specified");
            this.notifyUsers = true;
        }
        if (params.containsKey(KEY_FINGER_PRINT) && this.VALUES_FINGERPRINT.contains(params.get(KEY_FINGER_PRINT))) {
            this.fingerPrintPolicy = params.get(KEY_FINGER_PRINT);
        } else {
            this.log.debug((Object)"Defaulting to fingerprint policy of 'forward'");
            this.fingerPrintPolicy = "forward";
        }
    }

    public abstract boolean handleMessage(Message var1, MessageHandlerContext var2) throws MessagingException;

    protected boolean canHandleMessage(Message message, MessageHandlerExecutionMonitor monitor) throws MessagingException {
        this.deleteEmail = false;
        if (message.isSet(Flags.Flag.DELETED)) {
            monitor.messageRejected(message, "This message was already deleted. Likely cause: mail handler failed to complete last time.");
            this.deleteEmail = false;
            return false;
        }
        if (!this.fingerPrintCheck(message, monitor)) {
            monitor.messageRejected(message, "Rejecting message due to failed fingerprint check.");
            return false;
        }
        if (this.checkBulk(message, monitor)) {
            monitor.messageRejected(message, "Rejecting message due to failed bulk check.");
            return false;
        }
        if (this.catchEmail != null) {
            boolean forCatchAll;
            try {
                forCatchAll = MailUtils.hasRecipient((String)this.catchEmail, (Message)message);
            }
            catch (MessagingException exception) {
                this.deleteEmail = false;
                this.log.debug((Object)"Could not parse message recipients. Assuming message is bad.", (Throwable)exception);
                String text = this.getI18nBean().getText("admin.errors.bad.destination.address");
                monitor.error(text, (Throwable)exception);
                monitor.messageRejected(message, text);
                return false;
            }
            if (!forCatchAll) {
                this.deleteEmail = false;
                monitor.messageRejected(message, "The messages recipient(s) does not match catch mail list.");
                this.logCantHandleRecipients(message, monitor);
                return false;
            }
            this.deleteEmail = true;
        }
        if (this.getMailLoopDetectionService().isPotentialMessageLoop(message)) {
            monitor.markMessageForDeletion(this.getI18nBean().getText("jmp.admin.potential.mail.loop"));
            return !this.handleBulk(monitor);
        }
        return true;
    }

    protected boolean checkBulk(Message message, MessageHandlerExecutionMonitor messageHandlerExecutionMonitor) {
        try {
            if (KEY_BULK.equalsIgnoreCase(this.getPrecedenceHeader(message)) || this.isDeliveryStatus(message) || this.isAutoSubmitted(message)) {
                return this.handleBulk(messageHandlerExecutionMonitor);
            }
            return false;
        }
        catch (MessagingException mex) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Error occurred while looking for bulk headers - assuming not bulk email: " + mex.getMessage()), (Throwable)mex);
            }
            return false;
        }
    }

    private boolean handleBulk(MessageHandlerExecutionMonitor messageHandlerExecutionMonitor) {
        if (this.bulk != null) {
            if ("ignore".equalsIgnoreCase(this.bulk)) {
                this.log.debug((Object)"Ignoring email with bulk delivery type");
                this.deleteEmail = false;
                return true;
            }
            if ("forward".equalsIgnoreCase(this.bulk)) {
                this.log.debug((Object)"Forwarding email with bulk delivery type");
                messageHandlerExecutionMonitor.error(this.getI18nBean().getText("admin.forward.bulk.mail"));
                this.deleteEmail = false;
                return true;
            }
            if (VALUE_BULK_DELETE.equalsIgnoreCase(this.bulk)) {
                this.log.debug((Object)"Deleting email with bulk delivery type");
                this.deleteEmail = true;
                return true;
            }
        }
        return false;
    }

    boolean fingerPrintCheck(Message message, MessageHandlerExecutionMonitor messageHandlerExecutionMonitor) {
        boolean fingerPrintClean = true;
        List<String> fingerPrintHeaders = this.getFingerPrintHeader(message);
        String instanceFingerPrint = this.jiraApplicationContext.getFingerPrint();
        if (!fingerPrintHeaders.isEmpty()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"JIRA fingerprints found on on incoming email message: ");
                for (String fingerPrintHeader : fingerPrintHeaders) {
                    this.log.debug((Object)("fingerprint: " + fingerPrintHeader));
                }
            }
            if (fingerPrintHeaders.contains(instanceFingerPrint)) {
                this.log.warn((Object)("Received message carrying this JIRA instance fingerprint (" + instanceFingerPrint + ")"));
                if ("accept".equalsIgnoreCase(this.fingerPrintPolicy)) {
                    this.log.debug((Object)"Handler is configured to accept such messages. Beware of mail loops: JRA-12467");
                } else if ("forward".equalsIgnoreCase(this.fingerPrintPolicy)) {
                    this.log.debug((Object)"Forwarding fingerprinted email.");
                    messageHandlerExecutionMonitor.markMessageForDeletion(this.getI18nBean().getText("admin.forward.mail.loop"));
                    fingerPrintClean = false;
                } else if ("ignore".equalsIgnoreCase(this.fingerPrintPolicy)) {
                    this.log.debug((Object)"Handler is configured to ignore this message.");
                    fingerPrintClean = false;
                }
            } else {
                this.log.info((Object)"Received message with another JIRA instance's fingerprint");
            }
        }
        return fingerPrintClean;
    }

    List<String> getFingerPrintHeader(Message message) {
        List<String> headers = Collections.emptyList();
        try {
            String[] headerArray = message.getHeader("X-JIRA-FingerPrint");
            if (headerArray != null) {
                headers = Arrays.asList(headerArray);
            }
        }
        catch (MessagingException e) {
            this.log.error((Object)"Failed to get mail header X-JIRA-FingerPrint");
        }
        return headers;
    }

    protected Collection<ChangeItemBean> createAttachmentsForMessage(Message message, final Issue issue, final MessageHandlerContext context) throws IOException, MessagingException {
        final ArrayList attachmentChangeItems = Lists.newArrayList();
        final ApplicationUser reporter = this.getReporter(message, context);
        boolean attachPermission = this.permissionManager.hasPermission(19, issue, reporter);
        final boolean attachmentsAllowed = this.applicationProperties.getOption("jira.option.allowattachments");
        AttachmentHandler attachmentHandler = attachmentsAllowed && attachPermission ? new AttachmentHandler(){

            @Override
            public void handlePart(Part part, Message containingMessage) throws IOException, MessagingException {
                ChangeItemBean changeItemBean;
                if (AbstractMessageHandler.this.shouldAttach(part, containingMessage) && (changeItemBean = AbstractMessageHandler.this.createAttachmentWithPart(part, reporter, issue, context)) != null) {
                    attachmentChangeItems.add(changeItemBean);
                }
            }

            @Override
            public void summarize() {
            }
        } : new AttachmentHandler(){
            private final List<String> skippedFiles = Lists.newArrayList();

            @Override
            public void handlePart(Part part, Message containingMessage) throws IOException, MessagingException {
                String filenameForAttachment;
                if (AbstractMessageHandler.this.shouldAttach(part, containingMessage) && StringUtils.isNotBlank((String)(filenameForAttachment = AbstractMessageHandler.this.getFilenameForAttachment(part)))) {
                    this.skippedFiles.add(filenameForAttachment);
                }
            }

            @Override
            public void summarize() {
                if (!this.skippedFiles.isEmpty()) {
                    String message;
                    String string = message = !attachmentsAllowed ? AbstractMessageHandler.this.getI18nBean().getText("jmp.handler.attachments.disabled") : AbstractMessageHandler.this.getI18nBean().getText("jmp.handler.attachments.no.create.permission", reporter.getName(), issue.getProjectObject().getKey());
                    if (AbstractMessageHandler.this.log.isDebugEnabled()) {
                        AbstractMessageHandler.this.log.debug((Object)(message + StringUtils.join(this.skippedFiles, (String)", ")));
                    }
                    String comment = message + "\n - " + StringUtils.join(this.skippedFiles, (String)"\n - ");
                    context.createComment(issue, reporter, comment, false);
                }
            }
        };
        Object messageContent = message.getContent();
        if (messageContent instanceof Multipart) {
            this.handleMultipart((Multipart)messageContent, message, attachmentHandler);
        } else if ("attachment".equalsIgnoreCase(message.getDisposition())) {
            this.log.debug((Object)"Trying to add attachment to issue from attachment only message.");
            attachmentHandler.handlePart((Part)message, null);
        }
        attachmentHandler.summarize();
        return attachmentChangeItems;
    }

    private void handleMultipart(Multipart multipart, Message message, AttachmentHandler attachmentHandler) throws MessagingException, IOException {
        int n = multipart.getCount();
        for (int i = 0; i < n; ++i) {
            BodyPart part;
            Object partContent;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)String.format("Adding attachments for multi-part message. Part %d of %d.", i + 1, n));
            }
            if ((partContent = (part = multipart.getBodyPart(i)).getContent()) instanceof Multipart) {
                this.handleMultipart((Multipart)partContent, message, attachmentHandler);
                continue;
            }
            attachmentHandler.handlePart((Part)part, message);
        }
    }

    private boolean isMessageInReplyToAnother(Message containingMessage, Message attachedMessage) throws MessagingException, ParseException {
        String attachMessageId = this.getMessageId(attachedMessage);
        Object[] replyToIds = containingMessage.getHeader(HEADER_IN_REPLY_TO);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Checking if attachment was reply to containing message:");
            this.log.debug((Object)("\tAttachment mesage id: " + attachMessageId));
            this.log.debug((Object)("\tNew message reply to values: " + Arrays.toString(replyToIds)));
        }
        if (replyToIds != null) {
            for (String string : replyToIds) {
                if (string == null || !string.equalsIgnoreCase(attachMessageId)) continue;
                return true;
            }
        }
        return false;
    }

    String getMessageId(Message message) throws MessagingException, ParseException {
        String[] originalMessageIds = message.getHeader(HEADER_MESSAGE_ID);
        if (originalMessageIds == null || originalMessageIds.length == 0) {
            String msg = "Could not retrieve Message-ID header from message: " + message;
            this.log.debug((Object)msg);
            throw new ParseException(msg);
        }
        return originalMessageIds[0];
    }

    protected final boolean shouldAttach(Part part, Message containingMessage) throws MessagingException, IOException {
        boolean attach;
        Assertions.notNull((String)"part", (Object)part);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Checking if attachment should be added to issue:");
            this.log.debug((Object)("\tContent-Type: " + part.getContentType()));
            this.log.debug((Object)("\tContent-Disposition: " + part.getDisposition()));
        }
        if (this.isJiraGeneratedAttachment(part)) {
            this.log.debug((Object)"Attachment detected as JIRA generated attachment - skipping.");
            attach = false;
        } else if (MailUtils.isPartMessageType((Part)part) && null != containingMessage) {
            this.log.debug((Object)"Attachment detected as a rfc/822 message.");
            attach = this.attachMessagePart(part, containingMessage);
        } else if (this.isPartAttachment(part)) {
            this.log.debug((Object)"Attachment detected as an 'Attachment'.");
            attach = this.attachAttachmentsParts(part);
        } else if (MailUtils.isPartInline((Part)part)) {
            this.log.debug((Object)"Attachment detected as an inline element.");
            attach = this.attachInlineParts(part);
        } else if (MailUtils.isPartPlainText((Part)part)) {
            this.log.debug((Object)"Attachment detected as plain text.");
            attach = this.attachPlainTextParts(part);
        } else if (MailUtils.isPartHtml((Part)part)) {
            this.log.debug((Object)"Attachment detected as HTML.");
            attach = this.attachHtmlParts(part);
        } else if (MailUtils.isPartRelated((Part)containingMessage)) {
            this.log.debug((Object)"Attachment detected as related content.");
            attach = this.attachRelatedPart(part);
        } else {
            attach = false;
        }
        if (this.log.isDebugEnabled()) {
            if (attach) {
                this.log.debug((Object)"Attachment was added to issue");
            } else {
                this.log.debug((Object)"Attachment was ignored.");
            }
        }
        return attach;
    }

    private boolean isJiraGeneratedAttachment(Part part) throws MessagingException {
        return new GeneratedAttachmentRecogniser(part).isJiraGeneratedAttachment();
    }

    private boolean isPartAttachment(Part part) throws MessagingException {
        return MailUtils.isPartAttachment((Part)part) || StringUtils.isNotBlank((String)part.getFileName()) && StringUtils.isNotBlank((String)part.getContentType()) && part.getSize() > 0;
    }

    protected void addCommentIndicatingAttachmentFailureAndMarkForDeletion(Issue issue, MessageHandlerContext context, Exception e) {
        this.log.error((Object)("Exception while adding attachments to " + issue.getKey() + ". Some attachments from the message might be missing. Making a note on the issue."), (Throwable)e);
        context.createComment(issue, null, this.getI18nBean().getText("jmp.handler.attachments.failed"), true);
        context.getMonitor().markMessageForDeletion(this.getI18nBean().getText("jmp.handler.attachments.failed"));
    }

    protected abstract boolean attachPlainTextParts(Part var1) throws MessagingException, IOException;

    protected abstract boolean attachHtmlParts(Part var1) throws MessagingException, IOException;

    protected boolean attachInlineParts(Part part) throws MessagingException, IOException {
        return !MailUtils.isContentEmpty((Part)part) && !MailUtils.isPartSignaturePKCS7((Part)part);
    }

    protected boolean attachAttachmentsParts(Part part) throws MessagingException, IOException {
        return !MailUtils.isContentEmpty((Part)part) && !MailUtils.isPartSignaturePKCS7((Part)part);
    }

    protected boolean attachMessagePart(Part messagePart, Message containingMessage) throws IOException, MessagingException {
        boolean keep = false;
        if (!this.shouldIgnoreEmailMessageAttachments()) {
            if (!this.isReplyMessagePart(messagePart, containingMessage)) {
                boolean bl = keep = !MailUtils.isContentEmpty((Part)messagePart);
                if (!keep && this.log.isDebugEnabled()) {
                    this.log.debug((Object)"Attachment not attached to issue: Message is empty.");
                }
            } else {
                this.log.debug((Object)"Attachment not attached to issue: Detected as reply.");
            }
        } else {
            this.log.debug((Object)"Attachment not attached to issue: Message attachment has been disabled.");
        }
        return keep;
    }

    protected boolean attachRelatedPart(Part part) throws IOException, MessagingException {
        return !MailUtils.isContentEmpty((Part)part);
    }

    boolean shouldIgnoreEmailMessageAttachments() {
        return this.applicationProperties.getOption("jira.option.ignore.email.message.attachments");
    }

    private boolean isReplyMessagePart(Part messagePart, Message containingMessage) throws IOException, MessagingException {
        boolean replyMessage;
        try {
            replyMessage = this.isMessageInReplyToAnother(containingMessage, (Message)messagePart.getContent());
        }
        catch (ParseException e) {
            this.log.debug((Object)"Can't tell if the message is in reply to the attached message -- will attach it in case");
            replyMessage = false;
        }
        return replyMessage;
    }

    protected ChangeItemBean createAttachmentWithPart(Part part, ApplicationUser reporter, Issue issue, MessageHandlerContext context) throws IOException {
        String issueKey = issue != null ? issue.getKey() : "null";
        File file = null;
        try {
            String validatedFilename;
            String contentType = MailUtils.getContentType((Part)part);
            String rawFilename = part.getFileName();
            String filename = this.getFilenameForAttachment(part);
            file = this.getFileFromPart(part, issueKey);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("part=" + part));
                this.log.debug((Object)("Filename=" + filename + ", content type=" + contentType + ", content=" + part.getContent()));
            }
            if ((validatedFilename = this.renameFileIfInvalid(filename, issue, reporter, context)) == null || file == null) {
                this.log.debug((Object)"Ignoring attachment with null filename/file.");
                ChangeItemBean changeItemBean = null;
                return changeItemBean;
            }
            ChangeItemBean cib = context.createAttachment(file, validatedFilename, contentType, reporter, issue);
            if (cib != null) {
                this.log.debug((Object)("Created attachment " + rawFilename + " for issue " + issueKey));
                ChangeItemBean changeItemBean = cib;
                return changeItemBean;
            }
            this.log.debug((Object)("Encountered an error creating the attachment " + rawFilename + " for issue " + issueKey));
            ChangeItemBean changeItemBean = null;
            return changeItemBean;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage(), e);
        }
        finally {
            if (file != null) {
                file.delete();
            }
        }
    }

    protected String getFilenameForAttachment(Part part) throws MessagingException, IOException {
        String filename = this.getFilenameFromPart(part);
        if (null == filename) {
            if (MailUtils.isPartMessageType((Part)part)) {
                filename = this.getFilenameFromMessageSubject(part);
            } else if (MailUtils.isPartInline((Part)part)) {
                filename = this.getFilenameFromContentType(part);
            }
        }
        if (null != filename && StringUtils.isBlank((String)filename)) {
            String message = "Having found a filename(aka filename is not null) filename should not be an empty string, but is...";
            this.log.warn((Object)"Having found a filename(aka filename is not null) filename should not be an empty string, but is...");
            filename = null;
        }
        return filename;
    }

    private String getFilenameFromPart(Part part) throws MessagingException, IOException {
        String filename = part.getFileName();
        if (null != filename) {
            filename = MailUtils.fixMimeEncodedFilename((String)filename);
        }
        return filename;
    }

    private String getFilenameFromMessageSubject(Part part) throws MessagingException, IOException {
        Message message = (Message)part.getContent();
        String filename = message.getSubject();
        if (StringUtils.isBlank((String)filename)) {
            try {
                filename = this.getMessageId(message);
            }
            catch (ParseException e) {
                filename = ATTACHED_MESSAGE_FILENAME;
            }
        }
        return filename;
    }

    private String getFilenameFromContentType(Part part) throws MessagingException, IOException {
        String subMimeType;
        String filename = DEFAULT_BINARY_FILE_NAME;
        String contentType = MailUtils.getContentType((Part)part);
        int slash = contentType.indexOf("/");
        if (-1 != slash && !(subMimeType = contentType.substring(slash + 1)).equals("bin")) {
            filename = contentType.substring(0, slash) + '.' + subMimeType;
        }
        return filename;
    }

    protected String renameFileIfInvalid(String filename, Issue issue, ApplicationUser reporter, MessageHandlerContext context) {
        if (filename == null) {
            return null;
        }
        String replacedFilename = fileNameCharacterCheckerUtil.replaceInvalidChars(filename, '_');
        if (!filename.equals(replacedFilename)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Filename was invalid: replacing '" + filename + "' with '" + replacedFilename + "'"));
            }
            String body = this.getI18nBean().getText("admin.renamed.file.cause.of.invalid.chars", filename, replacedFilename);
            context.createComment(issue, reporter, body, false);
            return replacedFilename;
        }
        return filename;
    }

    @VisibleForTesting
    File createTempFile() throws IOException {
        return File.createTempFile("tempattach", "dat");
    }

    protected File getFileFromPart(Part part, String issueKey) throws IOException, MessagingException {
        File tempFile;
        try {
            tempFile = this.createTempFile();
        }
        catch (IOException ex) {
            throw new IOException("Unable to create a temporary file to copy attachment into.", ex);
        }
        FileOutputStream out = new FileOutputStream(tempFile);
        try {
            part.getDataHandler().writeTo((OutputStream)out);
            File file = tempFile;
            return file;
        }
        catch (IOException ex) {
            tempFile.delete();
            throw new IOException("Error while reading attachment, resulting file was incomplete and has been removed.", ex);
        }
        catch (MessagingException ex) {
            tempFile.delete();
            throw ex;
        }
        finally {
            IOUtils.closeQuietly((OutputStream)out);
        }
    }

    protected ApplicationUser getReporter(Message message, MessageHandlerContext context) throws MessagingException {
        ApplicationUser reporter = this.getMessageUserProcessor().getAuthorFromSender(message);
        if (reporter == null) {
            if (this.createUsers) {
                reporter = this.createUserForReporter(message, context);
            }
            if (this.reporteruserName != null && reporter == null) {
                this.log.info((Object)("Sender(s) " + MailUtils.getSenders((Message)message) + " not registered in JIRA. Using configured default reporter '" + this.reporteruserName + "'."));
                reporter = UserUtils.getUser((String)this.reporteruserName);
            }
        }
        return reporter;
    }

    protected MessageUserProcessor getMessageUserProcessor() {
        return this.messageUserProcessor;
    }

    @Nullable
    protected ApplicationUser createUserForReporter(Message message, MessageHandlerContext context) {
        ApplicationUser reporter = null;
        try {
            if (!this.userManager.hasWritableDirectory()) {
                context.getMonitor().warning("Unable to create user for reporter because no user directories are writable.");
                return null;
            }
            this.log.debug((Object)"Cannot find reporter for message. Creating new user.");
            Address[] senders = message.getFrom();
            if (senders == null || senders.length == 0) {
                context.getMonitor().error("Cannot retrieve sender information from the message.");
                return null;
            }
            InternetAddress internetAddress = (InternetAddress)senders[0];
            String reporterEmail = internetAddress.getAddress();
            if (!TextUtils.verifyEmail((String)reporterEmail)) {
                context.getMonitor().error("The email address [" + reporterEmail + "] received was not valid. Ensure that your mail client specified a valid 'From:' mail header. (see JRA-12203)");
                return null;
            }
            String fullName = internetAddress.getPersonal();
            if (fullName == null || fullName.trim().length() == 0) {
                fullName = reporterEmail;
            }
            String password = null;
            reporter = this.notifyUsers ? context.createUser(reporterEmail, password, reporterEmail, fullName, Integer.valueOf(1)) : context.createUser(reporterEmail, password, reporterEmail, fullName, null);
            if (context.isRealRun()) {
                this.log.debug((Object)("Created user " + reporterEmail + " as reporter of email-based issue."));
            }
        }
        catch (Exception e) {
            context.getMonitor().error("Error occurred while automatically creating a new user from email", (Throwable)e);
        }
        return reporter;
    }

    protected String getPrecedenceHeader(Message message) throws MessagingException {
        String precedenceHeader;
        String[] precedenceHeaders = message.getHeader("Precedence");
        if (precedenceHeaders != null && precedenceHeaders.length > 0 && !StringUtils.isBlank((String)(precedenceHeader = precedenceHeaders[0]))) {
            return precedenceHeader;
        }
        return null;
    }

    protected boolean isDeliveryStatus(Message message) throws MessagingException {
        String contentType = message.getContentType();
        if ("multipart/report".equalsIgnoreCase(MailUtils.getContentType((String)contentType))) {
            return contentType.toLowerCase().contains("report-type=delivery-status");
        }
        Object[] returnPaths = message.getHeader("Return-Path");
        if (!ArrayUtils.isEmpty((Object[])returnPaths)) {
            return Iterables.any((Iterable)Lists.newArrayList((Object[])returnPaths), (Predicate)new Predicate<String>(){

                public boolean apply(@Nullable String input) {
                    return "<>".equalsIgnoreCase(input);
                }
            });
        }
        return false;
    }

    protected boolean isAutoSubmitted(Message message) throws MessagingException {
        String[] autoSub = message.getHeader("Auto-Submitted");
        if (autoSub != null) {
            for (String auto : autoSub) {
                if ("no".equalsIgnoreCase(auto)) continue;
                return true;
            }
        }
        return false;
    }

    protected void recordIncomingMessageId(MailThreadManager.MailAction mailAction, Message message, Issue issue, MessageHandlerContext context) throws MessagingException {
        String[] messageIds = message.getHeader("Message-Id");
        if (messageIds != null && messageIds.length > 0) {
            Address[] froms = message.getFrom();
            String fromAddress = null;
            if (froms != null && froms.length > 0) {
                fromAddress = ((InternetAddress)froms[0]).getAddress();
            }
            if (context.isRealRun()) {
                ComponentAccessor.getMailThreadManager().storeIncomingMessageId(messageIds[0], fromAddress, issue, mailAction);
            }
        }
    }

    protected Issue getAssociatedIssue(Message message) {
        return ComponentAccessor.getMailThreadManager().getAssociatedIssueObject(message);
    }

    protected I18nHelper getI18nBean() {
        return ComponentAccessor.getJiraAuthenticationContext().getI18nHelper();
    }

    private void logCantHandleRecipients(Message message, MessageHandlerExecutionMonitor monitor) {
        Address[] addresses;
        try {
            addresses = message.getAllRecipients();
        }
        catch (MessagingException e) {
            monitor.info("Cannot handle message. Unable to parse recipient addresses.", (Throwable)e);
            return;
        }
        if (addresses == null || addresses.length == 0) {
            monitor.info("Cannot handle message.  No recipient addresses found.");
        } else {
            StringBuilder recipients = new StringBuilder();
            for (int i = 0; i < addresses.length; ++i) {
                InternetAddress email = (InternetAddress)addresses[i];
                if (email == null) continue;
                recipients.append(email.getAddress());
                if (i + 1 >= addresses.length) continue;
                recipients.append(", ");
            }
            monitor.info("Cannot handle message as the recipient(s) (" + recipients.toString() + ") do not match the catch email " + this.catchEmail);
        }
    }

    void setFingerPrintPolicy(String fingerPrintPolicy) {
        this.fingerPrintPolicy = fingerPrintPolicy;
    }

    protected MailLoopDetectionService getMailLoopDetectionService() {
        return (MailLoopDetectionService)ComponentAccessor.getOSGiComponentInstanceOfType(MailLoopDetectionService.class);
    }

    private static interface AttachmentHandler {
        public void handlePart(Part var1, Message var2) throws IOException, MessagingException;

        public void summarize();
    }
}

