/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.mail.handlers;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.core.util.map.EasyMap;
import com.atlassian.jira.JiraApplicationContext;
import com.atlassian.jira.JiraException;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.event.type.EventType;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.issue.util.IssueUpdateBean;
import com.atlassian.jira.issue.util.IssueUpdater;
import com.atlassian.jira.mail.MailLoggingManager;
import com.atlassian.jira.plugins.mail.handlers.AbstractMessageHandler;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.service.util.ServiceUtils;
import com.atlassian.jira.service.util.handler.MessageHandlerContext;
import com.atlassian.jira.service.util.handler.MessageHandlerErrorCollector;
import com.atlassian.jira.service.util.handler.MessageUserProcessor;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import java.util.Collection;
import java.util.Map;
import javax.mail.Message;
import javax.mail.MessagingException;
import org.apache.commons.lang.StringUtils;

@ExperimentalApi
public abstract class AbstractCommentHandler
extends AbstractMessageHandler {
    public static final String KEY_ONBEHALFUSER_KEY = "onbehalfuserkey";
    private final PermissionManager permissionManager;
    private final IssueUpdater issueUpdater;
    private String commentOnBehalfKey;

    protected AbstractCommentHandler() {
        this(ComponentAccessor.getPermissionManager(), (IssueUpdater)ComponentAccessor.getComponent(IssueUpdater.class), ComponentAccessor.getUserManager(), ComponentAccessor.getApplicationProperties(), (JiraApplicationContext)ComponentAccessor.getComponent(JiraApplicationContext.class), (MailLoggingManager)ComponentAccessor.getComponent(MailLoggingManager.class), (MessageUserProcessor)ComponentAccessor.getComponent(MessageUserProcessor.class));
    }

    protected AbstractCommentHandler(PermissionManager permissionManager, IssueUpdater issueUpdater, ApplicationProperties applicationProperties, JiraApplicationContext jiraApplicationContext) {
        super(applicationProperties, jiraApplicationContext);
        this.permissionManager = permissionManager;
        this.issueUpdater = issueUpdater;
    }

    protected AbstractCommentHandler(PermissionManager permissionManager, IssueUpdater issueUpdater, UserManager userManager, ApplicationProperties applicationProperties, JiraApplicationContext jiraApplicationContext, MailLoggingManager mailLoggingManager, MessageUserProcessor messageUserProcessor) {
        super(userManager, applicationProperties, jiraApplicationContext, mailLoggingManager, messageUserProcessor);
        this.permissionManager = permissionManager;
        this.issueUpdater = issueUpdater;
    }

    @Override
    public void init(Map<String, String> params, MessageHandlerErrorCollector errorCollector) {
        super.init(params, errorCollector);
        this.commentOnBehalfKey = params.get(KEY_ONBEHALFUSER_KEY);
    }

    @Override
    protected ApplicationUser getReporter(Message message, MessageHandlerContext context) throws MessagingException {
        ApplicationUser reporter = super.getReporter(message, context);
        Issue issue = this.getIssueFromMessage(message);
        if (context.isRealRun() && (reporter == null || !this.permissionManager.hasPermission(15, issue, reporter)) && StringUtils.isNotBlank((String)this.commentOnBehalfKey)) {
            return this.userManager.getUserByKey(this.commentOnBehalfKey);
        }
        return reporter;
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean handleMessage(Message message, MessageHandlerContext context) throws MessagingException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Issue getIssueFromMessage(Message message) throws MessagingException {
        String subject = message.getSubject();
        Issue issue = ServiceUtils.findIssueObjectInString((String)subject);
        if (issue == null) {
            issue = this.getAssociatedIssue(message);
        }
        return issue;
    }

    private void update(Collection<ChangeItemBean> attachmentsChangeItems, Issue issue, ApplicationUser reporter, Comment comment) throws JiraException {
        Long eventTypeId = AbstractCommentHandler.getEventTypeId(attachmentsChangeItems);
        IssueUpdateBean issueUpdateBean = new IssueUpdateBean(issue, issue, eventTypeId, reporter);
        issueUpdateBean.setComment(comment);
        if (attachmentsChangeItems != null && !attachmentsChangeItems.isEmpty()) {
            issueUpdateBean.setChangeItems(attachmentsChangeItems);
        }
        issueUpdateBean.setDispatchEvent(true);
        issueUpdateBean.setParams(EasyMap.build((Object)"eventsource", (Object)"action"));
        this.issueUpdater.doUpdate(issueUpdateBean, false);
    }

    public static Long getEventTypeId(Collection attachmentsChangeItems) {
        Long eventTypeId = EventType.ISSUE_COMMENTED_ID;
        if (attachmentsChangeItems != null && !attachmentsChangeItems.isEmpty()) {
            eventTypeId = EventType.ISSUE_UPDATED_ID;
        }
        return eventTypeId;
    }

    protected abstract String getEmailBody(Message var1) throws MessagingException;
}

