/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.lookandfeel.rest;

import com.atlassian.jira.lookandfeel.AutoLookAndFeelManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@Path(value="auto")
@Produces(value={"application/json"})
public class AutoLookAndFeelResource {
    private final AutoLookAndFeelManager autoLookAndFeelManager;
    private final JiraAuthenticationContext jiraAuthenticationContext;

    public AutoLookAndFeelResource(AutoLookAndFeelManager autoLookAndFeelManager, JiraAuthenticationContext jiraAuthenticationContext) {
        this.autoLookAndFeelManager = autoLookAndFeelManager;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    @GET
    @Path(value="justupdated")
    public Response isJustUpdated() {
        boolean justUpdated = this.autoLookAndFeelManager.isJustUpdated(this.jiraAuthenticationContext.getUser());
        return Response.ok((Object)new IsJustUpdatedBean(justUpdated)).build();
    }

    @PUT
    @Path(value="restorebackup")
    public Response restoreBackup() {
        this.autoLookAndFeelManager.restoreBackupColorScheme();
        return Response.noContent().build();
    }

    @XmlRootElement
    private static class IsJustUpdatedBean {
        @XmlElement
        private boolean isJustUpdated;

        public IsJustUpdatedBean(boolean isJustUpdated) {
            this.isJustUpdated = isJustUpdated;
        }
    }
}

