/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.lookandfeel.image;

import com.atlassian.jira.lookandfeel.image.ImageDescriptor;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.UrlValidator;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;

public class URLImageDescriptor
extends ImageDescriptor {
    private final I18nHelper i18nHelper;

    public URLImageDescriptor(String url, I18nHelper i18nHelper) throws IOException {
        this.i18nHelper = i18nHelper;
        if (!URLImageDescriptor.isUrlSupported(url)) {
            throw new IllegalArgumentException("The provided url is not supported.");
        }
        this.handleAbsoluteUrl(url);
    }

    private void handleAbsoluteUrl(String filename) throws IOException {
        URL url = new URL(filename);
        URLConnection urlConnection = url.openConnection();
        urlConnection.connect();
        this.contentType = urlConnection.getContentType();
        this.fileName = filename;
        this.imageData = urlConnection.getInputStream();
    }

    public static boolean isUrlSupported(String url) {
        return UrlValidator.isValid((String)url);
    }

    @Override
    public String getImageDescriptorType() {
        return this.i18nHelper.getText("jira.lookandfeel.urlimagedescriptor.type");
    }
}

