/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.lookandfeel.image;

import com.atlassian.jira.lookandfeel.image.ImageDescriptor;
import com.atlassian.jira.lookandfeel.image.ImageDescriptorFactory;
import com.atlassian.jira.lookandfeel.image.MultiPartImageDescriptor;
import com.atlassian.jira.lookandfeel.image.URLImageDescriptor;
import com.atlassian.jira.util.I18nHelper;
import java.io.IOException;
import webwork.multipart.MultiPartRequestWrapper;

public class ImageDescriptorFactoryImpl
implements ImageDescriptorFactory {
    private I18nHelper i18nHelper;

    public ImageDescriptorFactoryImpl(I18nHelper i18nHelper) {
        this.i18nHelper = i18nHelper;
    }

    @Override
    public boolean isUrlSupported(String url) {
        return URLImageDescriptor.isUrlSupported(url);
    }

    @Override
    public ImageDescriptor withUrl(String url) throws IOException {
        if (URLImageDescriptor.isUrlSupported(url)) {
            return new URLImageDescriptor(url, this.i18nHelper);
        }
        throw new IllegalArgumentException("The provided url is not supported.");
    }

    @Override
    public ImageDescriptor withRequest(String parameterName, MultiPartRequestWrapper multiPartRequest) throws IOException {
        return new MultiPartImageDescriptor(parameterName, multiPartRequest, this.i18nHelper);
    }
}

