/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.lookandfeel.filter;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.util.JiraHome;
import com.atlassian.jira.lookandfeel.filter.ImageDownloader;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class LogoInterceptor
implements Filter {
    private FilterConfig config;
    private JiraHome jiraHome;
    private final String JIRA_LOGO = "jira-logo-scaled.png";

    public void init(FilterConfig filterConfig) throws ServletException {
        this.config = filterConfig;
        this.jiraHome = (JiraHome)ComponentAccessor.getComponent(JiraHome.class);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest) {
            HttpServletResponse res = (HttpServletResponse)response;
            HttpServletRequest req = (HttpServletRequest)request;
            String requestURL = req.getRequestURL().toString();
            if (requestURL.endsWith("jira-logo-scaled.png")) {
                ImageDownloader downloader = new ImageDownloader();
                downloader.doDownload(req, res, this.config.getServletContext(), this.jiraHome.getHomePath() + "/logos/" + "jira-logo-scaled.png", true);
            }
        } else {
            chain.doFilter(request, response);
        }
    }

    public void destroy() {
    }
}

