/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.viewissue.web;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.plugin.customfield.CustomFieldTypeModuleDescriptor;
import com.atlassian.jira.plugin.viewissue.web.FieldModel;
import com.atlassian.jira.util.collect.MapBuilder;
import webwork.action.Action;

public class CustomFieldModel
extends FieldModel {
    private final Object value;
    private String fieldType = null;
    private String fieldTypeCompleteKey = null;
    private String styleClass = null;
    private boolean hasView = false;
    private String fieldHtml = null;

    public CustomFieldModel(FieldLayoutItem layoutItem, Issue issue, Action action) {
        super((Field)layoutItem.getOrderableField());
        CustomField customField = (CustomField)layoutItem.getOrderableField();
        CustomFieldTypeModuleDescriptor descriptor = customField.getCustomFieldType().getDescriptor();
        this.value = customField.getValue(issue);
        this.hasView = descriptor.isViewTemplateExists();
        if (this.hasView) {
            this.initialiseField(customField, layoutItem, issue, action, descriptor, this.value);
        }
    }

    private void initialiseField(CustomField customField, FieldLayoutItem layoutItem, Issue issue, Action action, CustomFieldTypeModuleDescriptor descriptor, Object value) {
        this.fieldType = descriptor.getKey();
        this.fieldTypeCompleteKey = descriptor.getCompleteKey();
        this.styleClass = "type-" + this.fieldType;
        if ("textarea".equals(this.fieldType) && value != null && ((String)value).length() > 255) {
            this.styleClass = this.styleClass + " twixified";
        }
        this.fieldHtml = customField.getViewHtml(layoutItem, action, issue, MapBuilder.build((Object)"view_issue", (Object)Boolean.TRUE));
    }

    public String getStyleClass() {
        return this.styleClass;
    }

    public boolean hasView() {
        return this.hasView;
    }

    public boolean hasValue() {
        return this.value != null;
    }

    public String getFieldHtml() {
        return this.fieldHtml;
    }

    public String getFieldType() {
        return this.fieldType;
    }

    @Override
    public FieldModel.FieldModelType getFieldModelType() {
        return FieldModel.FieldModelType.CUSTOM;
    }

    public String getFieldTypeCompleteKey() {
        return this.fieldTypeCompleteKey;
    }
}

