/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.viewissue.conditions;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.plugin.webfragment.conditions.AbstractJiraCondition;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.web.FieldVisibilityManager;
import com.atlassian.plugin.PluginAccessor;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class ShowDescriptionCondition
extends AbstractJiraCondition {
    private final PluginAccessor pluginAccessor;
    private final FieldVisibilityManager fieldVisibilityManager;
    private final IssueManager issueManager;
    private final ApplicationProperties applicationProperties;

    public ShowDescriptionCondition(PluginAccessor pluginAccessor, FieldVisibilityManager fieldVisibilityManager, IssueManager issueManager, ApplicationProperties applicationProperties) {
        this.pluginAccessor = pluginAccessor;
        this.fieldVisibilityManager = fieldVisibilityManager;
        this.issueManager = issueManager;
        this.applicationProperties = applicationProperties;
    }

    public boolean shouldDisplay(ApplicationUser user, JiraHelper jiraHelper) {
        Map params = jiraHelper.getContextParams();
        Issue issue = (Issue)params.get("issue");
        if (issue != null) {
            if (this.fieldVisibilityManager.isFieldHidden("description", issue)) {
                return false;
            }
            if (StringUtils.isNotBlank((String)issue.getDescription())) {
                return true;
            }
            if (this.pluginAccessor.isPluginEnabled("com.atlassian.jira.jira-issue-nav-plugin") && !this.applicationProperties.getOption("jira.issue.inline.edit.disabled") && this.issueManager.isEditable(issue, user)) {
                return true;
            }
        }
        return false;
    }
}

