/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.viewissue;

import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderer;
import com.atlassian.jira.issue.fields.screen.FieldScreenRendererFactory;
import com.atlassian.jira.issue.fields.util.FieldPredicates;
import com.atlassian.jira.issue.operation.IssueOperation;
import com.atlassian.jira.issue.operation.IssueOperations;
import com.atlassian.jira.issue.vote.VoteManager;
import com.atlassian.jira.issue.watchers.WatcherManager;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.plugin.profile.UserFormatManager;
import com.atlassian.jira.plugin.viewissue.web.CustomFieldModel;
import com.atlassian.jira.plugin.viewissue.web.FieldModelFactory;
import com.atlassian.jira.plugin.webfragment.CacheableContextProvider;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.web.FieldVisibilityManager;
import com.atlassian.plugin.PluginParseException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import webwork.action.Action;

public class PeopleBlockContextProvider
implements CacheableContextProvider {
    private static final String COMPOSED_BY_FIELDS = "composedByFields";
    private final ApplicationProperties applicationProperties;
    private final AvatarService avatarService;
    private final JiraAuthenticationContext authenticationContext;
    private final FieldScreenRendererFactory fieldScreenRendererFactory;
    private final FieldVisibilityManager fieldVisibilityManager;
    private final IssueManager issueManager;
    private final PermissionManager permissionManager;
    private final UserFormatManager userFormatManager;
    private final VoteManager voteManager;
    private final WatcherManager watcherManager;
    private FieldModelFactory fieldModelFactory;

    public PeopleBlockContextProvider(ApplicationProperties applicationProperties, AvatarService avatarService, JiraAuthenticationContext authenticationContext, FieldScreenRendererFactory fieldScreenRendererFactory, FieldVisibilityManager fieldVisibilityManager, IssueManager issueManager, PermissionManager permissionManager, UserFormatManager userFormatManager, VoteManager voteManager, WatcherManager watcherManager, FieldModelFactory fieldModelFactory) {
        this.applicationProperties = applicationProperties;
        this.avatarService = avatarService;
        this.authenticationContext = authenticationContext;
        this.fieldScreenRendererFactory = fieldScreenRendererFactory;
        this.fieldVisibilityManager = fieldVisibilityManager;
        this.issueManager = issueManager;
        this.permissionManager = permissionManager;
        this.userFormatManager = userFormatManager;
        this.voteManager = voteManager;
        this.watcherManager = watcherManager;
        this.fieldModelFactory = fieldModelFactory;
    }

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public Map<String, Object> getContextMap(Map<String, Object> context) {
        Issue issue = (Issue)context.get("issue");
        ApplicationUser user = this.authenticationContext.getLoggedInUser();
        Action action = (Action)context.get("action");
        MapBuilder paramsBuilder = MapBuilder.newBuilder(context);
        paramsBuilder.add((Object)"issue", (Object)issue);
        paramsBuilder.add((Object)"user", (Object)user);
        paramsBuilder.add((Object)"i18n", (Object)this.authenticationContext.getI18nHelper());
        paramsBuilder.add((Object)"peopleComponent", (Object)this);
        paramsBuilder.add((Object)"assigneeVisible", (Object)this.isAssigneeVisible(issue));
        paramsBuilder.add((Object)"reporterVisible", (Object)this.isReporterVisible(issue));
        paramsBuilder.add((Object)"showAssignToMe", (Object)this.showAssignToMe(user, issue));
        List watchers = this.watcherManager.getCurrentWatcherUsernames(issue);
        paramsBuilder.add((Object)"watchers", (Object)watchers);
        paramsBuilder.add((Object)"watching", (Object)(user != null && watchers.contains(user.getUsername()) ? 1 : 0));
        paramsBuilder.add((Object)"voting", (Object)this.voteManager.hasVoted(user, issue));
        paramsBuilder.add((Object)"isResolved", (Object)(issue.getResolution() != null ? 1 : 0));
        String reporterId = issue.getReporterId();
        paramsBuilder.add((Object)"isCurrentUserReporter", (Object)(StringUtils.isNotBlank((String)reporterId) && user != null && reporterId.equals(user.getKey()) ? 1 : 0));
        paramsBuilder.add((Object)"isLoggedIn", (Object)(user != null ? 1 : 0));
        paramsBuilder.add((Object)"votingEnabled", (Object)this.applicationProperties.getOption("jira.option.voting"));
        paramsBuilder.add((Object)"watchingEnabled", (Object)this.applicationProperties.getOption("jira.option.watching"));
        paramsBuilder.add((Object)"canManageWatcherList", (Object)this.permissionManager.hasPermission(ProjectPermissions.MANAGE_WATCHERS, issue, user));
        paramsBuilder.add((Object)"canViewVotersAndWatchers", (Object)this.permissionManager.hasPermission(ProjectPermissions.VIEW_VOTERS_AND_WATCHERS, issue, user));
        if (this.fieldModelFactory.hasRequestedFields(context)) {
            paramsBuilder.add((Object)"fields", this.fieldModelFactory.getFieldModels(context));
        } else {
            paramsBuilder.add((Object)"userCustomFields", this.createCustomFieldModels(issue, action));
        }
        return paramsBuilder.toMap();
    }

    private boolean showAssignToMe(ApplicationUser currentUser, Issue issue) {
        return currentUser != null && !currentUser.getKey().equals(issue.getAssigneeId()) && this.permissionManager.hasPermission(ProjectPermissions.ASSIGN_ISSUES, issue, currentUser) && this.permissionManager.hasPermission(ProjectPermissions.ASSIGNABLE_USER, issue, currentUser) && this.issueManager.isEditable(issue);
    }

    public String getUniqueContextKey(Map<String, Object> context) {
        Issue issue = (Issue)context.get("issue");
        ApplicationUser user = this.authenticationContext.getLoggedInUser();
        return issue.getId() + 47L + (user == null ? "" : user.getUsername());
    }

    private List<CustomFieldModel> createCustomFieldModels(Issue issue, Action action) {
        FieldScreenRenderer screenRenderer = this.fieldScreenRendererFactory.getFieldScreenRenderer(issue, (IssueOperation)IssueOperations.VIEW_ISSUE_OPERATION, FieldPredicates.isCustomUserField());
        List fieldScreenRenderLayoutItems = screenRenderer.getAllScreenRenderItems();
        return fieldScreenRenderLayoutItems.stream().map(layoutItem -> new CustomFieldModel(layoutItem.getFieldLayoutItem(), issue, action)).collect(Collectors.toList());
    }

    private boolean isAssigneeVisible(Issue issue) {
        return this.isFieldVisible(issue, "assignee");
    }

    private boolean isReporterVisible(Issue issue) {
        return this.isFieldVisible(issue, "reporter");
    }

    private boolean isFieldVisible(Issue issue, String field) {
        return !this.fieldVisibilityManager.isFieldHidden(issue.getProjectId(), field, issue.getIssueTypeId());
    }

    public String getAssigneeDisplayHtml(Issue issue) {
        if (issue == null) {
            return "";
        }
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("avatarURL", this.getAvatarURL(issue.getAssignee()));
        parameters.put("defaultFullName", this.authenticationContext.getI18nHelper().getText("common.status.unassigned"));
        return this.userFormatManager.formatUserkey(issue.getAssigneeId(), "avatarFullNameHover", "issue_summary_assignee", parameters);
    }

    public String getReporterDisplayHtml(Issue issue) {
        if (issue == null) {
            return "";
        }
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("avatarURL", this.getAvatarURL(issue.getReporter()));
        return this.userFormatManager.formatUserkey(issue.getReporterId(), "avatarFullNameHover", "issue_summary_reporter", parameters);
    }

    private String getAvatarURL(ApplicationUser user) {
        return this.avatarService.getAvatarURL(this.authenticationContext.getLoggedInUser(), user, Avatar.Size.NORMAL).toString();
    }
}

