/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.viewissue;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.link.IssueLinkManager;
import com.atlassian.jira.issue.link.LinkCollection;
import com.atlassian.jira.issue.link.RemoteIssueLinkManager;
import com.atlassian.jira.plugin.viewissue.issuelink.IssueLinkContext;
import com.atlassian.jira.plugin.viewissue.issuelink.IssueLinkTypeContext;
import com.atlassian.jira.plugin.viewissue.issuelink.LocalIssueLinkUtils;
import com.atlassian.jira.plugin.viewissue.issuelink.RemoteIssueLinkComparator;
import com.atlassian.jira.plugin.viewissue.issuelink.RemoteIssueLinkUtils;
import com.atlassian.jira.plugin.webfragment.CacheableContextProvider;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.velocity.VelocityRequestContext;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jira.web.FieldVisibilityManager;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginParseException;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class LinkBlockContextProvider
implements CacheableContextProvider {
    private static final int DEFAULT_DISPLAYED_LINK_COUNT = 5;
    private final IssueLinkManager issueLinkManager;
    private final JiraAuthenticationContext authenticationContext;
    private final FieldVisibilityManager fieldVisibilityManager;
    private final PermissionManager permissionManager;
    private final VelocityRequestContextFactory velocityRequestContextFactory;
    private final RemoteIssueLinkManager remoteIssueLinkManager;
    private final PluginAccessor pluginAccessor;

    public LinkBlockContextProvider(IssueLinkManager issueLinkManager, JiraAuthenticationContext authenticationContext, FieldVisibilityManager fieldVisibilityManager, PermissionManager permissionManager, VelocityRequestContextFactory velocityRequestContextFactory, RemoteIssueLinkManager remoteIssueLinkManager, PluginAccessor pluginAccessor) {
        this.issueLinkManager = issueLinkManager;
        this.authenticationContext = authenticationContext;
        this.fieldVisibilityManager = fieldVisibilityManager;
        this.permissionManager = permissionManager;
        this.velocityRequestContextFactory = velocityRequestContextFactory;
        this.remoteIssueLinkManager = remoteIssueLinkManager;
        this.pluginAccessor = pluginAccessor;
    }

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public Map<String, Object> getContextMap(Map<String, Object> context) {
        MapBuilder paramsBuilder = MapBuilder.newBuilder(context);
        Issue issue = (Issue)context.get("issue");
        ApplicationUser loggedInUser = this.authenticationContext.getUser();
        I18nHelper i18n = this.authenticationContext.getI18nHelper();
        String baseUrl = this.velocityRequestContextFactory.getJiraVelocityRequestContext().getBaseUrl();
        Map<String, List<IssueLinkContext>> localRelationshipIssueLinkMap = this.getLocalIssueLinks(issue, loggedInUser, baseUrl);
        Map<String, List<IssueLinkContext>> remoteRelationshipIssueLinkMap = this.getRemoteIssueLinks(issue, baseUrl, i18n);
        List<IssueLinkTypeContext> issueLinkTypeContexts = this.sortLinkTypes(localRelationshipIssueLinkMap, remoteRelationshipIssueLinkMap);
        int displayedLinkCount = this.getDisplayedLinkCount(this.velocityRequestContextFactory.getJiraVelocityRequestContext());
        String hiddenLinkStats = this.calculateHiddenLinkStats(issueLinkTypeContexts, displayedLinkCount);
        paramsBuilder.addAll(this.velocityRequestContextFactory.getDefaultVelocityParams(MapBuilder.emptyMap(), this.authenticationContext));
        paramsBuilder.add((Object)"issueLinkTypeContexts", issueLinkTypeContexts);
        paramsBuilder.add((Object)"displayedLinkCount", (Object)displayedLinkCount);
        paramsBuilder.add((Object)"hiddenLinkStats", (Object)hiddenLinkStats);
        paramsBuilder.add((Object)"hasIssueLinks", (Object)(!issueLinkTypeContexts.isEmpty() ? 1 : 0));
        paramsBuilder.add((Object)"canLink", (Object)this.permissionManager.hasPermission(21, issue, loggedInUser));
        paramsBuilder.add((Object)"defaultLinkIcon", (Object)(baseUrl + "/images/icons/generic_link_16.png"));
        return paramsBuilder.toMap();
    }

    private List<IssueLinkTypeContext> sortLinkTypes(Map<String, List<IssueLinkContext>> localIssueLinks, Map<String, List<IssueLinkContext>> remoteIssueLinks) {
        ArrayList issueLinkTypeContexts = Lists.newArrayList();
        Set<String> localRelationshipSet = localIssueLinks.keySet();
        ArrayList localRelationships = Lists.newArrayList(localRelationshipSet);
        Collections.sort(localRelationships, String.CASE_INSENSITIVE_ORDER);
        for (String relationship : localRelationships) {
            ArrayList issueLinkContexts = Lists.newArrayList((Iterable)localIssueLinks.get(relationship));
            if (remoteIssueLinks.containsKey(relationship)) {
                issueLinkContexts.addAll((Collection)remoteIssueLinks.get(relationship));
            }
            issueLinkTypeContexts.add(new IssueLinkTypeContext(relationship, issueLinkContexts));
        }
        Sets.SetView remoteOnlyRelationshipSet = Sets.difference(remoteIssueLinks.keySet(), localRelationshipSet);
        ArrayList remoteOnlyRelationships = Lists.newArrayList((Iterable)remoteOnlyRelationshipSet);
        Collections.sort(remoteOnlyRelationships, String.CASE_INSENSITIVE_ORDER);
        for (String relationship : remoteOnlyRelationships) {
            issueLinkTypeContexts.add(new IssueLinkTypeContext(relationship, remoteIssueLinks.get(relationship)));
        }
        return issueLinkTypeContexts;
    }

    private int getDisplayedLinkCount(VelocityRequestContext requestContext) {
        if (Boolean.parseBoolean(requestContext.getRequestParameter("expandLinks"))) {
            return Integer.MAX_VALUE;
        }
        return 5;
    }

    private String calculateHiddenLinkStats(List<IssueLinkTypeContext> linkTypeContexts, int displayedLinkCount) {
        ArrayList stats = Lists.newArrayListWithExpectedSize((int)linkTypeContexts.size());
        int remainingLinksToDisplay = displayedLinkCount;
        for (IssueLinkTypeContext linkTypeContext : linkTypeContexts) {
            int linkCount = linkTypeContext.getIssueLinkContexts().size();
            if (linkCount > remainingLinksToDisplay) {
                int hiddenLinkCount = linkCount - remainingLinksToDisplay;
                stats.add(hiddenLinkCount + " " + linkTypeContext.getRelationship());
                remainingLinksToDisplay = 0;
                continue;
            }
            remainingLinksToDisplay -= linkCount;
        }
        return Joiner.on((String)", ").join((Iterable)stats);
    }

    private Map<String, List<IssueLinkContext>> getRemoteIssueLinks(Issue issue, String baseUrl, I18nHelper i18n) {
        ArrayList remoteIssueLinks = Lists.newArrayList((Iterable)this.remoteIssueLinkManager.getRemoteIssueLinksForIssue(issue));
        Collections.sort(remoteIssueLinks, new RemoteIssueLinkComparator(i18n.getText("issuelinking.remote.link.relationship.default")));
        return RemoteIssueLinkUtils.convertToIssueLinkContexts(remoteIssueLinks, issue.getId(), baseUrl, i18n, this.pluginAccessor);
    }

    private Map<String, List<IssueLinkContext>> getLocalIssueLinks(Issue issue, ApplicationUser loggedInUser, String baseUrl) {
        LinkCollection linkCollection = this.issueLinkManager.getLinkCollection(issue, loggedInUser);
        return LocalIssueLinkUtils.convertToIssueLinkContexts(linkCollection, issue.getId(), baseUrl, this.fieldVisibilityManager);
    }

    public String getUniqueContextKey(Map<String, Object> context) {
        Issue issue = (Issue)context.get("issue");
        ApplicationUser user = this.authenticationContext.getUser();
        return issue.getId() + "/" + (user == null ? "" : user.getName());
    }
}

