/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.viewissue;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderer;
import com.atlassian.jira.issue.fields.screen.FieldScreenRendererFactory;
import com.atlassian.jira.issue.fields.util.FieldPredicates;
import com.atlassian.jira.issue.operation.IssueOperation;
import com.atlassian.jira.issue.operation.IssueOperations;
import com.atlassian.jira.plugin.viewissue.web.CustomFieldModel;
import com.atlassian.jira.plugin.viewissue.web.DateFieldModel;
import com.atlassian.jira.plugin.viewissue.web.DateFieldModelFactory;
import com.atlassian.jira.plugin.viewissue.web.FieldModelFactory;
import com.atlassian.jira.plugin.webfragment.CacheableContextProvider;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.web.FieldVisibilityManager;
import com.atlassian.plugin.PluginParseException;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import webwork.action.Action;

public class DateBlockContextProvider
implements CacheableContextProvider {
    private final FieldVisibilityManager fieldVisibilityManager;
    private final JiraAuthenticationContext authenticationContext;
    private final FieldScreenRendererFactory fieldScreenRendererFactory;
    private final FieldManager fieldManager;
    private final DateFieldModelFactory dateFieldModelFactory;
    private final FieldModelFactory fieldModelFactory;

    public DateBlockContextProvider(FieldVisibilityManager fieldVisibilityManager, JiraAuthenticationContext authenticationContext, FieldScreenRendererFactory fieldScreenRendererFactory, FieldManager fieldManager, DateFieldModelFactory dateFieldModelFactory, FieldModelFactory fieldModelFactory) {
        this.fieldVisibilityManager = fieldVisibilityManager;
        this.authenticationContext = authenticationContext;
        this.fieldScreenRendererFactory = fieldScreenRendererFactory;
        this.fieldManager = fieldManager;
        this.dateFieldModelFactory = dateFieldModelFactory;
        this.fieldModelFactory = fieldModelFactory;
    }

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public Map<String, Object> getContextMap(Map<String, Object> context) {
        Issue issue = (Issue)context.get("issue");
        Action action = (Action)context.get("action");
        context.put("i18n", this.authenticationContext.getI18nHelper());
        MapBuilder paramsBuilder = MapBuilder.newBuilder(context);
        ArrayList dates = Lists.newArrayList();
        if (this.fieldModelFactory.hasRequestedFields(context)) {
            dates.addAll(this.fieldModelFactory.getFieldModels(context));
        } else {
            ArrayList systemDateFields = Lists.newArrayList();
            if (issue.getDueDate() != null && !this.fieldVisibilityManager.isFieldHidden("duedate", issue)) {
                systemDateFields.add(this.fieldManager.getField("duedate"));
            }
            systemDateFields.add(this.fieldManager.getField("created"));
            systemDateFields.add(this.fieldManager.getField("updated"));
            if (issue.getResolutionDate() != null) {
                systemDateFields.add(this.fieldManager.getField("resolutiondate"));
            }
            dates.addAll(this.getDateSystemFieldModels(systemDateFields, issue));
            dates.addAll(this.getDateCustomFieldModels(issue, action));
        }
        paramsBuilder.add((Object)"dates", (Object)dates);
        return paramsBuilder.toMap();
    }

    public String getUniqueContextKey(Map<String, Object> context) {
        Issue issue = (Issue)context.get("issue");
        ApplicationUser user = this.authenticationContext.getLoggedInUser();
        return issue.getId() + "/" + (user == null ? "" : user.getName());
    }

    private List<CustomFieldModel> getDateCustomFieldModels(Issue issue, Action action) {
        FieldScreenRenderer screenRenderer = this.fieldScreenRendererFactory.getFieldScreenRenderer(issue, (IssueOperation)IssueOperations.VIEW_ISSUE_OPERATION, FieldPredicates.isCustomDateField());
        List dateRenderItems = screenRenderer.getAllScreenRenderItems();
        return dateRenderItems.stream().map(layoutItem -> new CustomFieldModel(layoutItem.getFieldLayoutItem(), issue, action)).collect(Collectors.toList());
    }

    private List<DateFieldModel> getDateSystemFieldModels(List<Field> systemFields, Issue issue) {
        return systemFields.stream().filter(this.dateFieldModelFactory::isDateSystemField).map(field -> this.dateFieldModelFactory.toModel((Field)field, issue)).collect(Collectors.toList());
    }
}

