/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.viewissue;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.AttachmentManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.plugin.viewissue.AttachmentBlockContextHelper;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.web.bean.NonZipExpandableExtensions;
import com.atlassian.jira.web.component.ContentRenderingInstruction;
import com.atlassian.jira.web.component.ContentRenderingInstructionsProvider;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;

public class AttachmentBlockContentRenderingInstructionsProvider
implements ContentRenderingInstructionsProvider {
    private final AttachmentManager attachmentManager;
    private final AttachmentBlockContextHelper helper;
    private final JiraAuthenticationContext authenticationContext;
    private final NonZipExpandableExtensions nonZipExpandableExtensions;

    public AttachmentBlockContentRenderingInstructionsProvider(AttachmentManager attachmentManager, AttachmentBlockContextHelper helper, JiraAuthenticationContext authenticationContext) {
        this.attachmentManager = attachmentManager;
        this.helper = helper;
        this.authenticationContext = authenticationContext;
        this.nonZipExpandableExtensions = (NonZipExpandableExtensions)ComponentAccessor.getComponent(NonZipExpandableExtensions.class);
    }

    public ContentRenderingInstruction getInstruction(Map<String, Object> context) {
        Issue issue = (Issue)context.get("issue");
        List attachments = this.attachmentManager.getAttachments(issue);
        ApplicationUser user = this.authenticationContext.getUser();
        StringBuilder sb = new StringBuilder();
        for (Attachment attachment : attachments) {
            sb.append(attachment.getCreated().getTime()).append(this.helper.canDeleteAttachment(issue, attachment, user));
        }
        if (!attachments.isEmpty()) {
            sb.append(this.helper.getAttachmentOrder());
            sb.append(this.helper.getAttachmentSortBy());
            sb.append(this.helper.getAttachmentViewMode());
            sb.append(this.helper.getZipSupport());
            sb.append(this.helper.getMaximumNumberOfZipEntriesToShow());
            sb.append(this.nonZipExpandableExtensions.getNonExpandableExtensionsList());
        }
        return ContentRenderingInstruction.customContentId((String)DigestUtils.md5Hex((String)sb.toString()));
    }
}

