/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.gadgets.dashboard.internal.velocity;

import com.atlassian.gadgets.GadgetRequestContext;
import com.atlassian.gadgets.dashboard.internal.AbstractViewComponent;
import com.atlassian.gadgets.dashboard.internal.Dashboard;
import com.atlassian.gadgets.dashboard.internal.DashboardUrlBuilder;
import com.atlassian.gadgets.dashboard.internal.DashboardWebItemFinder;
import com.atlassian.gadgets.dashboard.internal.Tab;
import com.atlassian.gadgets.dashboard.internal.velocity.DashboardEmbedder;
import com.atlassian.gadgets.util.WebItemFinder;
import com.atlassian.plugin.webresource.WebResourceManager;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.soy.renderer.SoyException;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.atlassian.templaterenderer.RenderingException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

class DashboardView
extends AbstractViewComponent {
    private final Dashboard dashboard;
    private final boolean writable;
    private final boolean canAddExternalGadgetsToDirectory;
    private final String username;
    private final SoyTemplateRenderer renderer;
    private final Iterable<Tab> tabs;
    private final GadgetRequestContext gadgetRequestContext;
    private final int maxGadgets;
    private final DashboardEmbedder dashboardEmbedder;
    private final DashboardWebItemFinder webItemFinder;
    private final DashboardUrlBuilder urlBuilder;
    private final I18nResolver i18n;
    private final WebResourceManager webResourceManager;
    static final String TEMPLATE_RESOURCE_KEY = "com.atlassian.gadgets.dashboard:server-side-soy-templates";
    static final String TEMPLATE_NAME = "Gadgets.Templates.Dashboard.chrome";

    DashboardView(SoyTemplateRenderer renderer, Iterable<Tab> tabs, Dashboard dashboard, String username, int maxGadgets, GadgetRequestContext gadgetRequestContext, boolean writable, boolean canAddExternalGadgetsToDirectory, DashboardEmbedder dashboardEmbedder, DashboardWebItemFinder webItemFinder, DashboardUrlBuilder urlBuilder, I18nResolver i18n, WebResourceManager webResourceManager) {
        super(dashboard.getId().toString(), dashboard.getTitle());
        this.renderer = renderer;
        this.tabs = tabs;
        this.dashboard = dashboard;
        this.username = username;
        this.gadgetRequestContext = gadgetRequestContext;
        this.writable = writable;
        this.canAddExternalGadgetsToDirectory = canAddExternalGadgetsToDirectory;
        this.maxGadgets = maxGadgets;
        this.dashboardEmbedder = dashboardEmbedder;
        this.webItemFinder = webItemFinder;
        this.i18n = i18n;
        this.urlBuilder = urlBuilder;
        this.webResourceManager = webResourceManager;
    }

    public final void writeTo(Writer writer) throws RenderingException, IOException {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("isDraggable", this.writable);
        context.put("layoutsJson", this.getLayoutsJson());
        context.put("localeCountry", this.gadgetRequestContext.getLocale().getCountry());
        context.put("localeLang", this.gadgetRequestContext.getLocale().getLanguage());
        context.put("menuItems", this.getMenuItems());
        context.put("paramsJson", this.getParamsJson());
        context.put("tabs", this.getTabsForSoy());
        context.put("title", this.dashboard.getTitle());
        try {
            this.webResourceManager.requireResourcesForContext("atl.dashboard");
            writer.write(this.renderer.render(TEMPLATE_RESOURCE_KEY, TEMPLATE_NAME, context));
        }
        catch (SoyException e) {
            throw new RuntimeException(e);
        }
    }

    private List<Object> getMenuItems() {
        ImmutableList.Builder builder = ImmutableList.builder();
        ImmutableList.Builder toolItemsBuilder = ImmutableList.builder();
        for (WebItemFinder.WebItem webItem : this.webItemFinder.findDashboardMenuItems(this.dashboard.getId(), this.username)) {
            builder.add((Object)ImmutableMap.of((Object)"link", this.constructLinkFromWebItem(webItem, "")));
        }
        for (WebItemFinder.WebItem webItem : this.webItemFinder.findDashboardToolsMenuItems(this.dashboard.getId(), this.username)) {
            boolean groupMaker = webItem.getStyleClass() != null && webItem.getStyleClass().contains("groupmarker");
            toolItemsBuilder.add((Object)ImmutableMap.of((Object)"link", this.constructLinkFromWebItem(webItem, "item-link"), (Object)"styleClass", (Object)(groupMaker ? "dropdown-item groupmarker" : "dropdown-item")));
        }
        this.addToolsDropDownMenu((ImmutableList.Builder<Object>)builder, (ImmutableList<Object>)toolItemsBuilder.build());
        return builder.build();
    }

    private void addToolsDropDownMenu(ImmutableList.Builder<Object> builder, ImmutableList<Object> toolItems) {
        if (toolItems.size() > 0) {
            builder.add((Object)ImmutableMap.of((Object)"useTemplate", (Object)"toolsDropdown", (Object)"list", (Object)ImmutableMap.of((Object)"items", toolItems), (Object)"trigger", (Object)ImmutableMap.of((Object)"id", (Object)"dashboard-tools-dropdown", (Object)"styleClass", (Object)"aui-dd-link lnk", (Object)"text", (Object)this.i18n.getText("dashboard.menu.tools"))));
        }
    }

    private Map<String, Object> constructLinkFromWebItem(WebItemFinder.WebItem webItem, String styleClassPrefix) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        if (webItem.getLink().getId() != null) {
            builder.put((Object)"id", (Object)webItem.getLink().getId());
        }
        if (webItem.getStyleClass() != null) {
            builder.put((Object)"styleClass", (Object)(styleClassPrefix + " " + webItem.getStyleClass()));
        }
        builder.put((Object)"isTopMenu", (Object)styleClassPrefix.equals(""));
        builder.put((Object)"href", (Object)webItem.getLink().getDisplayableUrl());
        builder.put((Object)"text", (Object)webItem.getLabel().getDisplayableLabel());
        return builder.build();
    }

    private String getLayoutsJson() {
        JSONObject json = new JSONObject();
        ImmutableList.Builder builder = ImmutableList.builder();
        try {
            if (this.tabs.iterator().hasNext()) {
                for (Tab tab : this.tabs) {
                    boolean active = tab.getDashboardId().equals((Object)this.dashboard.getId());
                    JSONObject layout = new JSONObject(this.dashboardEmbedder.dashboardToJsonObject(this.dashboard, this.gadgetRequestContext, this.writable, active).toString());
                    layout.put("uri", (Object)tab.getTabUri().toASCIIString());
                    layout.put("active", active);
                    builder.add((Object)layout);
                }
            } else {
                JSONObject layout = new JSONObject(this.dashboardEmbedder.dashboardToJsonObject(this.dashboard, this.gadgetRequestContext, this.writable, true).toString());
                layout.put("active", true);
                builder.add((Object)layout);
            }
            json.put("layouts", (Collection)builder.build());
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        return json.toString();
    }

    private List<Object> getTabsForSoy() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Tab tab : this.tabs) {
            builder.add((Object)ImmutableMap.of((Object)"title", (Object)tab.getTitle(), (Object)"uri", (Object)tab.getTabUri().toASCIIString(), (Object)"active", (Object)tab.getDashboardId().equals((Object)this.dashboard.getId())));
        }
        return builder.build();
    }

    private String getParamsJson() {
        JSONObject json = new JSONObject();
        try {
            json.put("layoutAction", (Object)this.urlBuilder.buildDashboardLayoutUrl(this.dashboard.getId()));
            json.put("canAddExternalGadgetsToDirectory", this.canAddExternalGadgetsToDirectory);
            json.put("writable", this.writable);
            json.put("maxGadgets", this.maxGadgets);
            json.put("dashboardUrl", (Object)this.urlBuilder.buildDashboardUrl(this.dashboard.getId()));
            json.put("dashboardDirectoryResourceUrl", (Object)this.urlBuilder.buildDashboardDirectoryResourceUrl());
            json.put("dashboardResourceUrl", (Object)this.urlBuilder.buildDashboardResourceUrl(this.dashboard.getId()));
            json.put("dashboardDirectoryUrl", (Object)this.urlBuilder.buildDashboardDirectoryUrl(this.dashboard.getId()));
            json.put("dashboardDirectoryBaseUrl", (Object)this.urlBuilder.buildDashboardDirectoryBaseUrl());
            json.put("dashboardDiagnosticsUrl", (Object)this.urlBuilder.buildDashboardDiagnosticsRelativeUrl());
            json.put("errorGadgetUrl", (Object)this.urlBuilder.buildErrorGadgetUrl());
            json.put("securityTokensUrl", (Object)this.urlBuilder.buildSecurityTokensUrl());
            json.put("gadgetDirectoryAdminUrl", (Object)this.urlBuilder.buildGadgetDirectoryAdminRelativeUrl());
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        return json.toString();
    }
}

