/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.gadgets.dashboard.internal.rest.representations;

import com.atlassian.fugue.Option;
import com.atlassian.fugue.Options;
import com.atlassian.gadgets.GadgetId;
import com.atlassian.gadgets.GadgetRequestContext;
import com.atlassian.gadgets.dashboard.DashboardId;
import com.atlassian.gadgets.dashboard.DashboardState;
import com.atlassian.gadgets.dashboard.internal.Dashboard;
import com.atlassian.gadgets.dashboard.internal.DashboardUrlBuilder;
import com.atlassian.gadgets.dashboard.internal.Gadget;
import com.atlassian.gadgets.dashboard.internal.impl.DashboardItem;
import com.atlassian.gadgets.dashboard.internal.impl.OpenSocialDashboardItem;
import com.atlassian.gadgets.dashboard.internal.impl.OpenSocialGadget;
import com.atlassian.gadgets.dashboard.internal.rest.representations.DashboardItemGadgetRepresentation;
import com.atlassian.gadgets.dashboard.internal.rest.representations.DashboardRepresentation;
import com.atlassian.gadgets.dashboard.internal.rest.representations.GadgetRenderingContext;
import com.atlassian.gadgets.dashboard.internal.rest.representations.GadgetRepresentation;
import com.atlassian.gadgets.dashboard.internal.rest.representations.GadgetUrlContainer;
import com.atlassian.gadgets.dashboard.internal.rest.representations.LocalRenderingContext;
import com.atlassian.gadgets.dashboard.internal.rest.representations.NullRenderedGadgetUriProvider;
import com.atlassian.gadgets.dashboard.internal.rest.representations.OpenSocialGadgetRepresentation;
import com.atlassian.gadgets.dashboard.internal.rest.representations.RenderedGadgetUriProvider;
import com.atlassian.gadgets.dashboard.internal.rest.representations.RenderedGadgetUriProviderImpl;
import com.atlassian.gadgets.dashboard.internal.rest.representations.RepresentationFactory;
import com.atlassian.gadgets.plugins.DashboardItemModule;
import com.atlassian.gadgets.util.DashboardItemConditionContext;
import com.atlassian.gadgets.view.RenderedGadgetUriBuilder;
import com.atlassian.plugin.ModuleCompleteKey;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.web.Condition;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RepresentationFactoryImpl
implements RepresentationFactory {
    private final RenderedGadgetUriBuilder renderedGadgetUriBuilder;
    private final DashboardUrlBuilder dashboardUrlBuilder;

    @Autowired
    public RepresentationFactoryImpl(@ComponentImport RenderedGadgetUriBuilder renderedGadgetUriBuilder, DashboardUrlBuilder dashboardUrlBuilder) {
        this.renderedGadgetUriBuilder = renderedGadgetUriBuilder;
        this.dashboardUrlBuilder = dashboardUrlBuilder;
    }

    @Override
    public DashboardRepresentation createDashboardRepresentation(final Dashboard dashboard, final GadgetRequestContext gadgetRequestContext, final boolean writable) {
        ImmutableList gadgets = ImmutableList.copyOf((Iterable)Iterables.concat((Iterable)Iterables.transform((Iterable)dashboard.getLayout().getColumnRange(), (Function)new Function<DashboardState.ColumnIndex, Iterable<GadgetRepresentation>>(){

            public Iterable<GadgetRepresentation> apply(final DashboardState.ColumnIndex columnIndex) {
                return Options.flatten((Iterable)Options.filterNone((Iterable)Iterables.transform(dashboard.getGadgetsInColumn(columnIndex), (Function)new Function<Gadget, Option<GadgetRepresentation>>(){

                    public Option<GadgetRepresentation> apply(Gadget gadget) {
                        return RepresentationFactoryImpl.this.createGadgetRepresentation(dashboard.getId(), gadget, gadgetRequestContext, writable, columnIndex);
                    }
                })));
            }
        })));
        return new DashboardRepresentation.Builder(dashboard).writable(writable).resourceUrl(this.dashboardUrlBuilder.buildDashboardResourceUrl(dashboard.getId())).gadgets((List<GadgetRepresentation>)gadgets).build();
    }

    @Override
    public Option<GadgetRepresentation> createGadgetRepresentation(final DashboardId dashboardId, Gadget gadget, final GadgetRequestContext gadgetRequestContext, boolean writable, DashboardState.ColumnIndex column) {
        GadgetUrlContainer gadgetUrls = this.gadgetUrlsForGadget(gadget, dashboardId, gadgetRequestContext, writable);
        final GadgetRenderingContext renderingContext = new GadgetRenderingContext(dashboardId, gadgetRequestContext, gadget, gadgetUrls, column);
        return gadget.accept(new Gadget.Visitor<Option<GadgetRepresentation>>(){

            @Override
            public Option<GadgetRepresentation> visit(OpenSocialGadget gadget) {
                return Option.some((Object)new OpenSocialGadgetRepresentation(gadget.getGadgetSpecUrl(), renderingContext));
            }

            @Override
            public Option<GadgetRepresentation> visit(OpenSocialDashboardItem gadget) {
                return this.createLocalGadgetRepresentation(gadget.getDashboardItemModule(), gadget.getState().getUserPrefs());
            }

            @Override
            public Option<GadgetRepresentation> visit(DashboardItem gadget) {
                if (this.evaluateCondition(gadget, dashboardId, gadgetRequestContext)) {
                    return this.createLocalGadgetRepresentation(gadget.getDashboardItemModule(), renderingContext.getSerializedContext());
                }
                return Option.none();
            }

            private boolean evaluateCondition(DashboardItem gadget, DashboardId dashboardId2, GadgetRequestContext gadgetRequestContext2) {
                Condition condition = gadget.getDashboardItemModule().getCondition();
                DashboardItemConditionContext conditionContext = this.getGadgetConditionContext(gadget, dashboardId2, gadgetRequestContext2);
                return condition.shouldDisplay(conditionContext.getSerializedContext());
            }

            private DashboardItemConditionContext getGadgetConditionContext(DashboardItem gadget, DashboardId dashboardId2, GadgetRequestContext gadgetRequestContext2) {
                ModuleCompleteKey completeKey = gadget.getState().getDashboardItemModuleId().getFullModuleKey();
                return DashboardItemConditionContext.forRendering((GadgetId)gadget.getId(), (DashboardId)dashboardId2, (ModuleCompleteKey)completeKey, (GadgetRequestContext)gadgetRequestContext2);
            }

            private Option<GadgetRepresentation> createLocalGadgetRepresentation(DashboardItemModule dashboardItemModule, Map<String, ?> context) {
                return Option.some((Object)new DashboardItemGadgetRepresentation(new LocalRenderingContext((String)dashboardItemModule.getAMDModule().getOrNull(), dashboardItemModule.isConfigurable(), RepresentationFactoryImpl.this.renderString(dashboardItemModule, context), (String)dashboardItemModule.getWebResourceKey().getOrNull()), renderingContext));
            }
        });
    }

    private GadgetUrlContainer gadgetUrlsForGadget(Gadget gadget, DashboardId dashboardId, GadgetRequestContext gadgetRequestContext, boolean writable) {
        RenderedGadgetUriProvider renderedGadgetUriProvider = new NullRenderedGadgetUriProvider();
        if (gadget instanceof OpenSocialGadget) {
            renderedGadgetUriProvider = new RenderedGadgetUriProviderImpl((OpenSocialGadget)gadget, gadgetRequestContext, this.renderedGadgetUriBuilder, writable);
        }
        return new GadgetUrlContainer(this.dashboardUrlBuilder, dashboardId, gadget, renderedGadgetUriProvider);
    }

    private String renderString(DashboardItemModule dashboardItemModule, Map<String, ?> context) {
        StringWriter sw = new StringWriter();
        dashboardItemModule.renderContent((Writer)sw, context);
        return sw.toString();
    }
}

