/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.gadgets.dashboard.internal.rest.representations;

import com.atlassian.gadgets.GadgetId;
import com.atlassian.gadgets.dashboard.Color;
import com.atlassian.gadgets.dashboard.internal.Gadget;
import com.atlassian.gadgets.dashboard.internal.rest.representations.GadgetRenderingContext;
import com.atlassian.gadgets.dashboard.internal.rest.representations.GadgetUrlContainer;
import com.atlassian.gadgets.dashboard.internal.rest.representations.UserPrefsRepresentation;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public abstract class GadgetRepresentation {
    @XmlElement
    private final String id;
    @XmlElement
    private final String title;
    @XmlElement
    private final String titleUrl;
    @XmlElement
    private final Integer height;
    @XmlElement
    private final Integer width;
    @XmlElement
    private final Color color;
    @XmlElement
    private final Integer column;
    @XmlElement
    private final String colorUrl;
    @XmlElement
    private final String gadgetUrl;
    @XmlElement
    private final Boolean isMaximizable;
    @XmlElement
    private final Boolean hasNonHiddenUserPrefs;
    @XmlElement
    private final UserPrefsRepresentation userPrefs;
    @XmlElement
    private final Boolean loaded;
    @XmlElement
    private final String errorMessage;
    @XmlElement
    protected String gadgetSpecUrl;
    @XmlElement
    protected String renderedGadgetUrl;
    @XmlElement
    protected String inlineHtml;
    @XmlElement
    protected String amdModule;
    @XmlElement
    protected String webResourceKey;
    @XmlElement
    protected Boolean configurable;
    @XmlElement
    protected Map<String, Object> context;

    private GadgetRepresentation() {
        this.id = "0";
        this.title = null;
        this.titleUrl = null;
        this.gadgetSpecUrl = null;
        this.height = null;
        this.width = null;
        this.color = null;
        this.isMaximizable = null;
        this.userPrefs = null;
        this.renderedGadgetUrl = null;
        this.colorUrl = null;
        this.gadgetUrl = null;
        this.hasNonHiddenUserPrefs = null;
        this.column = null;
        this.loaded = null;
        this.errorMessage = "";
        this.inlineHtml = null;
        this.amdModule = null;
        this.webResourceKey = null;
        this.configurable = null;
        this.context = new HashMap<String, Object>();
    }

    GadgetRepresentation(GadgetRenderingContext renderingContext) {
        Gadget gadget = renderingContext.getGadget();
        GadgetId gadgetId = gadget.getId();
        this.id = gadgetId.value();
        this.loaded = gadget.isLoaded();
        this.title = this.loaded != false ? gadget.getTitle() : null;
        this.height = this.loaded != false ? gadget.getHeight() : null;
        this.width = this.loaded != false ? gadget.getWidth() : null;
        this.color = gadget.getColor();
        this.isMaximizable = this.loaded != false ? Boolean.valueOf(gadget.isMaximizable()) : null;
        this.hasNonHiddenUserPrefs = this.loaded != false ? Boolean.valueOf(gadget.hasNonHiddenUserPrefs()) : null;
        this.column = renderingContext.getColumn() == null ? null : Integer.valueOf(renderingContext.getColumn().index());
        this.errorMessage = gadget.getErrorMessage();
        GadgetUrlContainer gadgetUrls = renderingContext.getGadgetUrls();
        this.titleUrl = gadgetUrls.getTitleUri();
        this.colorUrl = gadgetUrls.getColorUri();
        this.gadgetUrl = gadgetUrls.getGadgetUri();
        this.userPrefs = this.loaded != false ? new UserPrefsRepresentation(gadget.getUserPrefs(), gadgetUrls.getUserPrefsUri()) : null;
        this.context = renderingContext.getSerializedContext();
    }

    public Boolean getHasNonHiddenUserPrefs() {
        return this.hasNonHiddenUserPrefs;
    }

    public Boolean isLoaded() {
        return this.loaded;
    }

    public Color getColor() {
        return this.color;
    }

    public String getGadgetSpecUrl() {
        return this.gadgetSpecUrl;
    }

    public Integer getHeight() {
        return this.height;
    }

    public String getId() {
        return this.id;
    }

    public Boolean isMaximizable() {
        return this.isMaximizable;
    }

    public String getTitle() {
        return this.title;
    }

    public String getTitleUrl() {
        return this.titleUrl;
    }

    public UserPrefsRepresentation getUserPrefs() {
        return this.userPrefs;
    }

    public Integer getWidth() {
        return this.width;
    }

    public String getRenderedGadgetUrl() {
        return this.renderedGadgetUrl;
    }

    public String getColorUrl() {
        return this.colorUrl;
    }

    public String getGadgetUrl() {
        return this.gadgetUrl;
    }

    public Boolean hasNonHiddenUserPrefs() {
        return this.hasNonHiddenUserPrefs;
    }

    public Integer getColumn() {
        return this.column;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getInlineHtml() {
        return this.inlineHtml;
    }

    public String getAMDModule() {
        return this.amdModule;
    }

    public String getWebResourceKey() {
        return this.webResourceKey;
    }

    public Boolean isConfigurable() {
        return this.configurable;
    }

    public Map<String, Object> getContext() {
        return this.context;
    }
}

