/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.gadgets.dashboard.internal.rest;

import com.atlassian.gadgets.GadgetId;
import com.atlassian.gadgets.GadgetRequestContext;
import com.atlassian.gadgets.dashboard.DashboardId;
import com.atlassian.gadgets.dashboard.internal.Dashboard;
import com.atlassian.gadgets.dashboard.internal.DashboardRepository;
import com.atlassian.gadgets.dashboard.internal.InconsistentDashboardStateException;
import com.atlassian.gadgets.dashboard.internal.rest.UpdateGadgetUserPrefsHandler;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UpdateGadgetUserPrefsHandlerImpl
implements UpdateGadgetUserPrefsHandler {
    private final Log log = LogFactory.getLog(UpdateGadgetUserPrefsHandlerImpl.class);
    private static final String USER_PREF_PREFIX = "up_";
    private final DashboardRepository repository;
    private final I18nResolver i18n;

    @Autowired
    public UpdateGadgetUserPrefsHandlerImpl(DashboardRepository repository, @ComponentImport I18nResolver i18n) {
        this.repository = repository;
        this.i18n = i18n;
    }

    @Override
    public Response updateUserPrefs(DashboardId dashboardId, GadgetRequestContext gadgetRequestContext, GadgetId gadgetId, Map<String, String> prefs) {
        Dashboard dashboard = this.repository.get(dashboardId, gadgetRequestContext);
        try {
            dashboard.updateGadgetUserPrefs(gadgetId, this.adaptParameterMapToUserPrefValues(prefs));
            this.repository.save(dashboard);
            return Response.noContent().build();
        }
        catch (IllegalArgumentException iae) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).type("text/plain").entity((Object)this.i18n.getText("invalid.value.for.required.pref")).build();
        }
        catch (InconsistentDashboardStateException idse) {
            this.log.error((Object)"UpdateGadgetUserPrefsHandlerImpl: Unexpected error occurred: ", (Throwable)idse);
            return Response.status((Response.Status)Response.Status.CONFLICT).type("text/plain").entity((Object)this.i18n.getText("error.please.reload")).build();
        }
    }

    private Map<String, String> adaptParameterMapToUserPrefValues(Map<String, String> params) {
        HashMap<String, String> values = new HashMap<String, String>();
        for (String param : params.keySet()) {
            if (!param.startsWith(USER_PREF_PREFIX) || params.get(param) == null) continue;
            values.put(param.substring(USER_PREF_PREFIX.length()), params.get(param));
        }
        return values;
    }
}

