/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.gadgets.dashboard.internal.rest;

import com.atlassian.fugue.Option;
import com.atlassian.gadgets.GadgetId;
import com.atlassian.gadgets.GadgetRequestContext;
import com.atlassian.gadgets.GadgetRequestContextFactory;
import com.atlassian.gadgets.dashboard.Color;
import com.atlassian.gadgets.dashboard.DashboardId;
import com.atlassian.gadgets.dashboard.DashboardNotFoundException;
import com.atlassian.gadgets.dashboard.DashboardState;
import com.atlassian.gadgets.dashboard.internal.Dashboard;
import com.atlassian.gadgets.dashboard.internal.DashboardRepository;
import com.atlassian.gadgets.dashboard.internal.Gadget;
import com.atlassian.gadgets.dashboard.internal.rest.AddGadgetHandler;
import com.atlassian.gadgets.dashboard.internal.rest.ChangeGadgetColorHandler;
import com.atlassian.gadgets.dashboard.internal.rest.DeleteGadgetHandler;
import com.atlassian.gadgets.dashboard.internal.rest.UpdateGadgetUserPrefsHandler;
import com.atlassian.gadgets.dashboard.internal.rest.representations.GadgetRepresentation;
import com.atlassian.gadgets.dashboard.internal.rest.representations.RepresentationFactory;
import com.atlassian.gadgets.dashboard.spi.DashboardPermissionService;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.sal.api.message.I18nResolver;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.json.JSONObject;

@Scanned
@Path(value="{dashboardId}/gadget/{gadgetId}")
public class GadgetResource {
    private static final int HTTP_METHOD_NOT_ALLOWED = 405;
    private final Log log = LogFactory.getLog(this.getClass());
    private final DashboardPermissionService permissionService;
    private final DashboardRepository repository;
    private final GadgetRequestContextFactory gadgetRequestContextFactory;
    private final AddGadgetHandler addGadgetHandler;
    private final DeleteGadgetHandler deleteGadgetHandler;
    private final ChangeGadgetColorHandler changeGadgetColorHandler;
    private final UpdateGadgetUserPrefsHandler updateGadgetUserPrefsHandler;
    private final I18nResolver i18n;
    private RepresentationFactory representationFactory;

    public GadgetResource(@ComponentImport DashboardPermissionService permissionService, DashboardRepository repository, @ComponentImport GadgetRequestContextFactory gadgetRequestContextFactory, AddGadgetHandler addGadgetHandler, DeleteGadgetHandler deleteGadgetHandler, ChangeGadgetColorHandler changeGadgetColorHandler, UpdateGadgetUserPrefsHandler updateGadgetUserPrefsHandler, @ComponentImport I18nResolver i18n, RepresentationFactory representationFactory) {
        this.permissionService = permissionService;
        this.repository = repository;
        this.gadgetRequestContextFactory = gadgetRequestContextFactory;
        this.addGadgetHandler = addGadgetHandler;
        this.deleteGadgetHandler = deleteGadgetHandler;
        this.changeGadgetColorHandler = changeGadgetColorHandler;
        this.updateGadgetUserPrefsHandler = updateGadgetUserPrefsHandler;
        this.i18n = i18n;
        this.representationFactory = representationFactory;
    }

    @GET
    @AnonymousAllowed
    @Produces(value={"application/json", "application/xml"})
    public Response getRenderedGadget(@PathParam(value="dashboardId") DashboardId dashboardId, @PathParam(value="gadgetId") GadgetId gadgetId, @Context HttpServletRequest request) {
        this.log.debug((Object)("GadgetResource: GET received: dashboardId=" + dashboardId + ", gadgetId = " + gadgetId));
        return this.buildResponseWithGadgetRepresentation(dashboardId, gadgetId, request, this.fullGadgetRepresentation());
    }

    @GET
    @AnonymousAllowed
    @Path(value="/prefs")
    @Produces(value={"application/json", "application/xml"})
    public Response getUserPrefs(@PathParam(value="dashboardId") DashboardId dashboardId, @PathParam(value="gadgetId") GadgetId gadgetId, @Context HttpServletRequest request) {
        this.log.debug((Object)("GadgetResource: GET user preferences received: dashboardId=" + dashboardId + ", gadgetId = " + gadgetId));
        return this.buildResponseWithGadgetRepresentation(dashboardId, gadgetId, request, this.userPrefsRepresentation());
    }

    private Response buildResponseWithGadgetRepresentation(DashboardId dashboardId, GadgetId gadgetId, HttpServletRequest request, final Function<GadgetRepresentation, Object> gadgetRepresentationTransformer) {
        GadgetRequestContext requestContext = this.gadgetRequestContextFactory.get(request);
        if (!this.permissionService.isReadableBy(dashboardId, requestContext.getViewer())) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        return (Response)this.getGadgetRepresentation(dashboardId, gadgetId, requestContext).map((Function)new Function<GadgetRepresentation, Response>(){

            public Response apply(GadgetRepresentation gadgetRepresentation) {
                return Response.ok().entity(gadgetRepresentationTransformer.apply((Object)gadgetRepresentation)).build();
            }
        }).getOrElse((Object)Response.status((Response.Status)Response.Status.NOT_FOUND).build());
    }

    private Option<GadgetRepresentation> getGadgetRepresentation(DashboardId dashboardId, GadgetId gadgetId, GadgetRequestContext requestContext) {
        Dashboard dashboard = this.repository.get(dashboardId, requestContext);
        Gadget gadget = dashboard.findGadget(gadgetId);
        if (gadget == null) {
            return Option.none();
        }
        boolean isWriteable = this.permissionService.isWritableBy(dashboardId, requestContext.getViewer());
        return this.representationFactory.createGadgetRepresentation(dashboardId, gadget, requestContext, isWriteable, dashboard.getGadgetColumn(gadgetId));
    }

    private Function<GadgetRepresentation, Object> fullGadgetRepresentation() {
        return new Function<GadgetRepresentation, Object>(){

            public Object apply(GadgetRepresentation gadgetRepresentation) {
                return gadgetRepresentation;
            }
        };
    }

    private Function<GadgetRepresentation, Object> userPrefsRepresentation() {
        return new Function<GadgetRepresentation, Object>(){

            public Object apply(GadgetRepresentation gadgetRepresentation) {
                return gadgetRepresentation.getUserPrefs();
            }
        };
    }

    @DELETE
    @AnonymousAllowed
    public Response deleteGadget(@PathParam(value="dashboardId") DashboardId dashboardId, @PathParam(value="gadgetId") GadgetId gadgetId, @Context HttpServletRequest request) {
        GadgetRequestContext requestContext = this.gadgetRequestContextFactory.get(request);
        if (!this.permissionService.isWritableBy(dashboardId, requestContext.getViewer())) {
            this.log.warn((Object)"GadgetResource: DELETE: prevented gadget delete due to insufficient permission");
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        return this.deleteGadgetHandler.deleteGadget(dashboardId, requestContext, gadgetId);
    }

    @PUT
    @AnonymousAllowed
    public Response moveGadget(@PathParam(value="dashboardId") DashboardId targetDashboardId, @PathParam(value="gadgetId") GadgetId gadgetId, @Context HttpServletRequest request) {
        GadgetRequestContext requestContext = this.gadgetRequestContextFactory.get(request);
        if (!this.permissionService.isWritableBy(targetDashboardId, requestContext.getViewer())) {
            this.log.warn((Object)"GadgetResource: PUT: prevented gadget move due to insufficient permissions on target dashboard");
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            DashboardId sourceDashboardId = this.repository.findDashboardByGadgetId(gadgetId);
            if (!this.permissionService.isWritableBy(sourceDashboardId, requestContext.getViewer())) {
                this.log.warn((Object)"GadgetResource: PUT: prevented gadget move due to insufficient permissions on source dashboard");
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            return this.addGadgetHandler.moveGadget(targetDashboardId, gadgetId, sourceDashboardId, DashboardState.ColumnIndex.ZERO, 0, requestContext);
        }
        catch (DashboardNotFoundException dnfe) {
            this.log.error((Object)("DashboardResource: PUT: could not find a dashboard containing gadget " + gadgetId));
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).type("text/plain").entity((Object)this.i18n.getText("gadgetResource.error.moving.gadget", new Serializable[]{dnfe.getMessage()})).build();
        }
    }

    @PUT
    @AnonymousAllowed
    @Consumes(value={"application/json"})
    @Path(value="/color")
    public Response changeGadgetColor(@PathParam(value="dashboardId") DashboardId dashboardId, @PathParam(value="gadgetId") GadgetId gadgetId, @Context HttpServletRequest request, String entity) {
        Color color;
        JSONObject json;
        GadgetRequestContext requestContext = this.gadgetRequestContextFactory.get(request);
        if (!this.permissionService.isWritableBy(dashboardId, requestContext.getViewer())) {
            this.log.warn((Object)"GadgetResource: PUT: prevented gadget color change due to insufficient permission");
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            json = new JSONObject(entity);
        }
        catch (JSONException e) {
            return this.errorParsingJson(e);
        }
        String colorParam = null;
        try {
            colorParam = json.getString("color");
            color = Color.valueOf((String)colorParam);
        }
        catch (JSONException e) {
            return this.invalidColor(colorParam);
        }
        catch (IllegalArgumentException e) {
            return this.invalidColor(colorParam);
        }
        this.log.debug((Object)("GadgetResource: PUT /color: dashboardId=" + dashboardId + " gadgetId=" + gadgetId + " color=" + color));
        return this.changeGadgetColorHandler.setGadgetColor(dashboardId, requestContext, gadgetId, color);
    }

    private Response invalidColor(String colorParam) {
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).type("text/plain").entity((Object)this.i18n.getText("gadgetResource.invalid.color", new Serializable[]{colorParam, Arrays.toString(Color.values())})).build();
    }

    @PUT
    @AnonymousAllowed
    @Consumes(value={"application/json"})
    @Path(value="/prefs")
    public Response updateUserPrefsViaPUT(@PathParam(value="dashboardId") DashboardId dashboardId, @PathParam(value="gadgetId") GadgetId gadgetId, @Context HttpServletRequest request, String entity) {
        try {
            return this.updateUserPrefs(dashboardId, gadgetId, request, new JSONObject(entity));
        }
        catch (JSONException e) {
            return this.errorParsingJson(e);
        }
    }

    private Response updateUserPrefs(DashboardId dashboardId, GadgetId gadgetId, HttpServletRequest request, JSONObject params) {
        GadgetRequestContext requestContext = this.gadgetRequestContextFactory.get(request);
        if (!this.permissionService.isWritableBy(dashboardId, requestContext.getViewer())) {
            this.log.warn((Object)"GadgetResource: prevented gadget prefs change due to insufficient permission");
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        this.log.debug((Object)("GadgetResource: update /prefs: dashboardId=" + dashboardId + " gadgetId=" + gadgetId));
        return this.updateGadgetUserPrefsHandler.updateUserPrefs(dashboardId, requestContext, gadgetId, this.toMap(params));
    }

    private Map<String, String> toMap(JSONObject json) {
        ImmutableMap.Builder map = ImmutableMap.builder();
        Iterator i = json.keys();
        while (i.hasNext()) {
            String key = (String)i.next();
            try {
                map.put((Object)key, (Object)json.getString(key));
            }
            catch (JSONException e) {
                throw new RuntimeException("key '" + key + "' not found in " + json);
            }
        }
        return map.build();
    }

    private Response errorParsingJson(JSONException e) {
        this.log.warn((Object)"GadgetResource: POST: error parsing json", (Throwable)e);
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).type("text/plain").entity((Object)this.i18n.getText("dashboardResource.error.parsing.json", new Serializable[]{e.getMessage()})).build();
    }
}

