/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.gadgets.dashboard.internal.rest;

import com.atlassian.fugue.Option;
import com.atlassian.gadgets.DashboardItemModuleId;
import com.atlassian.gadgets.DashboardItemType;
import com.atlassian.gadgets.GadgetRequestContext;
import com.atlassian.gadgets.GadgetRequestContextFactory;
import com.atlassian.gadgets.dashboard.DashboardId;
import com.atlassian.gadgets.dashboard.DashboardState;
import com.atlassian.gadgets.dashboard.internal.Dashboard;
import com.atlassian.gadgets.dashboard.internal.DashboardRepository;
import com.atlassian.gadgets.dashboard.internal.impl.DashboardItemModuleIdFactory;
import com.atlassian.gadgets.dashboard.internal.rest.AddGadgetHandler;
import com.atlassian.gadgets.dashboard.internal.rest.ChangeLayoutHandler;
import com.atlassian.gadgets.dashboard.internal.rest.representations.DashboardItemBean;
import com.atlassian.gadgets.dashboard.internal.rest.representations.DashboardRepresentation;
import com.atlassian.gadgets.dashboard.internal.rest.representations.RepresentationFactory;
import com.atlassian.gadgets.dashboard.spi.DashboardPermissionService;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.sal.api.message.I18nResolver;
import com.google.common.base.Function;
import com.google.common.base.Supplier;
import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.json.JSONObject;

@Scanned
@Path(value="{dashboardId}")
public class DashboardResource {
    private final Log log = LogFactory.getLog(this.getClass());
    private final DashboardPermissionService permissionService;
    private final GadgetRequestContextFactory gadgetRequestContextFactory;
    private final AddGadgetHandler addGadgetHandler;
    private final ChangeLayoutHandler changeLayoutHandler;
    private final I18nResolver i18n;
    private final DashboardRepository repository;
    private final RepresentationFactory representationFactory;
    private final DashboardItemModuleIdFactory dashboardItemModuleIdFactory;

    public DashboardResource(@ComponentImport DashboardPermissionService permissionService, @ComponentImport GadgetRequestContextFactory gadgetRequestContextFactory, AddGadgetHandler addGadgetHandler, ChangeLayoutHandler changeLayoutHandler, DashboardRepository repository, RepresentationFactory representationFactory, @ComponentImport I18nResolver i18n, DashboardItemModuleIdFactory dashboardItemModuleIdFactory) {
        this.permissionService = permissionService;
        this.gadgetRequestContextFactory = gadgetRequestContextFactory;
        this.addGadgetHandler = addGadgetHandler;
        this.changeLayoutHandler = changeLayoutHandler;
        this.repository = repository;
        this.representationFactory = representationFactory;
        this.i18n = i18n;
        this.dashboardItemModuleIdFactory = dashboardItemModuleIdFactory;
    }

    @GET
    @AnonymousAllowed
    @Produces(value={"application/json", "application/xml"})
    public Response getDashboard(@PathParam(value="dashboardId") DashboardId dashboardId, @Context HttpServletRequest request) {
        this.log.debug((Object)("DashboardResource: GET received: dashboardId = " + dashboardId));
        GadgetRequestContext gadgetRequestContext = this.gadgetRequestContextFactory.get(request);
        if (!this.permissionService.isReadableBy(dashboardId, gadgetRequestContext.getViewer())) {
            this.log.warn((Object)"DashboardResource: GET: prevented getting dashboard representation due to insufficient permission");
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        Dashboard dashboard = this.repository.get(dashboardId, gadgetRequestContext);
        DashboardRepresentation representation = this.representationFactory.createDashboardRepresentation(dashboard, gadgetRequestContext, this.permissionService.isWritableBy(dashboardId, gadgetRequestContext.getViewer()));
        return Response.ok((Object)representation).build();
    }

    @GET
    @AnonymousAllowed
    @Path(value="numGadgets")
    @Produces(value={"text/plain"})
    public Response getNumGadgets(@PathParam(value="dashboardId") DashboardId dashboardId, @Context HttpServletRequest request) {
        this.log.debug((Object)("DashboardResource: GET numGadgets received: " + dashboardId));
        GadgetRequestContext gadgetRequestContext = this.gadgetRequestContextFactory.get(request);
        if (!this.permissionService.isReadableBy(dashboardId, gadgetRequestContext.getViewer())) {
            this.log.warn((Object)"DashboardResource: GET numGadgets: prevented getting number of gadgets on dashboard due to insufficient permission");
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        Dashboard dashboard = this.repository.get(dashboardId, gadgetRequestContext);
        return Response.ok((Object)String.valueOf(dashboard.getNumberOfGadgets())).build();
    }

    @POST
    @AnonymousAllowed
    @Consumes(value={"application/json"})
    public Response addGadget(final @PathParam(value="dashboardId") DashboardId dashboardId, final DashboardItemBean dashboardItemBean, final @Context HttpServletRequest request) {
        DashboardState.ColumnIndex columnIndex;
        try {
            columnIndex = DashboardState.ColumnIndex.from((int)dashboardItemBean.getColumnIndex());
        }
        catch (IllegalArgumentException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.i18n.getText("invalid.gadget.column", new Serializable[]{dashboardItemBean.getDashboardItemId()})).build();
        }
        return (Response)DashboardItemType.forName((String)dashboardItemBean.getType()).fold((Supplier)new Supplier<Response>(){

            public Response get() {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)DashboardResource.this.i18n.getText("dashboardResource.error.missing.type")).build();
            }
        }, (Function)new Function<DashboardItemType, Response>(){

            public Response apply(DashboardItemType dashboardItemType) {
                GadgetRequestContext requestContext = DashboardResource.this.gadgetRequestContextFactory.get(request);
                if (!DashboardResource.this.permissionService.isWritableBy(dashboardId, requestContext.getViewer())) {
                    DashboardResource.this.log.warn((Object)"DashboardResource: POST: prevented gadget addition due to insufficient permission");
                    return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
                }
                Option<DashboardItemModuleId> moduleId = DashboardResource.this.dashboardItemModuleIdFactory.createDashboardItemModuleId(dashboardItemType, dashboardItemBean.getDashboardItemId());
                if (moduleId.isEmpty()) {
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)DashboardResource.this.i18n.getText("invalid.gadget.spec.uri", new Serializable[]{dashboardItemBean.getDashboardItemId()})).build();
                }
                return DashboardResource.this.addGadgetHandler.addGadget(dashboardId, requestContext, (DashboardItemModuleId)moduleId.get(), columnIndex);
            }
        });
    }

    @POST
    @AnonymousAllowed
    @Consumes(value={"application/json"})
    @Path(value="/layout")
    public Response changeLayoutViaPOST(@PathParam(value="dashboardId") DashboardId dashboardId, @Context HttpServletRequest request, String entity) {
        return this.changeLayout(dashboardId, request, entity);
    }

    @PUT
    @AnonymousAllowed
    @Consumes(value={"application/json"})
    @Path(value="/layout")
    public Response changeLayoutViaPUT(@PathParam(value="dashboardId") DashboardId dashboardId, @Context HttpServletRequest request, String entity) {
        return this.changeLayout(dashboardId, request, entity);
    }

    private Response changeLayout(DashboardId dashboardId, HttpServletRequest request, String entity) {
        try {
            GadgetRequestContext requestContext = this.gadgetRequestContextFactory.get(request);
            this.log.debug((Object)("DashboardResource: changeLayout: dashboardId=" + dashboardId + " viewer=" + requestContext.getViewer()));
            if (!this.permissionService.isWritableBy(dashboardId, requestContext.getViewer())) {
                this.log.warn((Object)"DashboardResource: changeLayout: prevented layout change due to insufficient permission");
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            return this.changeLayoutHandler.changeLayout(dashboardId, requestContext, new JSONObject(entity));
        }
        catch (JSONException e) {
            return this.errorParsingJson(e);
        }
    }

    private Response errorParsingJson(JSONException e) {
        this.log.warn((Object)"DashboardResource: POST: error parsing json", (Throwable)e);
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).type("text/plain").entity((Object)this.i18n.getText("dashboardResource.error.parsing.json", new Serializable[]{e.getMessage()})).build();
    }
}

