/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.gadgets.dashboard.internal.rest;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.fugue.Effect;
import com.atlassian.fugue.Option;
import com.atlassian.gadgets.DashboardItemModuleId;
import com.atlassian.gadgets.DashboardItemModuleIdVisitor;
import com.atlassian.gadgets.GadgetId;
import com.atlassian.gadgets.GadgetParsingException;
import com.atlassian.gadgets.GadgetRequestContext;
import com.atlassian.gadgets.GadgetSpecUriNotAllowedException;
import com.atlassian.gadgets.GadgetSpecUrlChecker;
import com.atlassian.gadgets.LocalDashboardItemModuleId;
import com.atlassian.gadgets.OpenSocialDashboardItemModuleId;
import com.atlassian.gadgets.dashboard.DashboardId;
import com.atlassian.gadgets.dashboard.DashboardState;
import com.atlassian.gadgets.dashboard.Layout;
import com.atlassian.gadgets.dashboard.internal.Dashboard;
import com.atlassian.gadgets.dashboard.internal.DashboardRepository;
import com.atlassian.gadgets.dashboard.internal.Gadget;
import com.atlassian.gadgets.dashboard.internal.GadgetFactory;
import com.atlassian.gadgets.dashboard.internal.InconsistentDashboardStateException;
import com.atlassian.gadgets.dashboard.internal.event.DashboardItemAddedEvent;
import com.atlassian.gadgets.dashboard.internal.rest.AddGadgetHandler;
import com.atlassian.gadgets.dashboard.internal.rest.representations.GadgetRepresentation;
import com.atlassian.gadgets.dashboard.internal.rest.representations.RepresentationFactory;
import com.atlassian.gadgets.dashboard.spi.GadgetLayout;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.google.common.base.Function;
import com.google.common.base.Supplier;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import javax.ws.rs.core.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AddGadgetHandlerImpl
implements AddGadgetHandler {
    private final Log log = LogFactory.getLog(AddGadgetHandlerImpl.class);
    private final GadgetFactory gadgetFactory;
    private final DashboardRepository repository;
    private final RepresentationFactory representationFactory;
    private final I18nResolver i18n;
    private final TransactionTemplate txTemplate;
    private final EventPublisher eventPublisher;
    private final GadgetSpecUrlChecker gadgetSpecUrlChecker;

    @Autowired
    public AddGadgetHandlerImpl(GadgetFactory gadgetFactory, DashboardRepository repository, RepresentationFactory representationFactory, @ComponentImport I18nResolver i18n, @ComponentImport TransactionTemplate txTemplate, @ComponentImport EventPublisher eventPublisher, @ComponentImport GadgetSpecUrlChecker gadgetSpecUrlChecker) {
        this.gadgetFactory = gadgetFactory;
        this.repository = repository;
        this.representationFactory = representationFactory;
        this.i18n = i18n;
        this.txTemplate = txTemplate;
        this.eventPublisher = eventPublisher;
        this.gadgetSpecUrlChecker = gadgetSpecUrlChecker;
    }

    @Override
    public Response addGadget(DashboardId dashboardId, GadgetRequestContext gadgetRequestContext, DashboardItemModuleId dashboardItemModuleId) {
        return this.addGadget(dashboardId, gadgetRequestContext, dashboardItemModuleId, DashboardState.ColumnIndex.ZERO);
    }

    @Override
    public Response addGadget(DashboardId dashboardId, GadgetRequestContext gadgetRequestContext, DashboardItemModuleId moduleId, DashboardState.ColumnIndex columnIndex) {
        try {
            moduleId.accept((DashboardItemModuleIdVisitor)new DashboardItemModuleIdVisitor<Void>(){

                public Void visit(OpenSocialDashboardItemModuleId openSocialDashboardItemModuleId) {
                    AddGadgetHandlerImpl.this.gadgetSpecUrlChecker.assertRenderable(openSocialDashboardItemModuleId.getId());
                    return null;
                }

                public Void visit(LocalDashboardItemModuleId dashboardItemModuleId) {
                    return null;
                }
            });
            Gadget dashboardItem = this.gadgetFactory.createDashboardItem(moduleId, gadgetRequestContext);
            Dashboard dashboard = this.repository.get(dashboardId, gadgetRequestContext);
            dashboard.addGadget(columnIndex, dashboardItem);
            this.repository.save(dashboard);
            this.eventPublisher.publish((Object)new DashboardItemAddedEvent(gadgetRequestContext.getViewer(), dashboardId, moduleId));
            Option<GadgetRepresentation> representation = this.representationFactory.createGadgetRepresentation(dashboard.getId(), dashboardItem, gadgetRequestContext, true, columnIndex);
            return (Response)representation.fold((Supplier)new Supplier<Response>(){

                public Response get() {
                    return AddGadgetHandlerImpl.this.notFound();
                }
            }, (Function)new Function<GadgetRepresentation, Response>(){

                public Response apply(GadgetRepresentation representation) {
                    return Response.created((URI)URI.create(representation.getGadgetUrl())).entity((Object)representation).build();
                }
            });
        }
        catch (GadgetSpecUriNotAllowedException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.i18n.getText("gadget.spec.not.allowed", new Serializable[]{e.getMessage()})).build();
        }
        catch (GadgetParsingException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.i18n.getText("error.parsing.spec", new Serializable[]{e.getMessage()})).build();
        }
        catch (InconsistentDashboardStateException e) {
            this.log.error((Object)"AddGadgetHandlerImpl: Unexpected error occurred", (Throwable)e);
            return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)this.i18n.getText("error.please.reload")).build();
        }
    }

    @Override
    public Response moveGadget(final DashboardId targetDashboardId, final GadgetId gadgetId, final DashboardId sourceDashboardId, final DashboardState.ColumnIndex columnIndex, final int rowIndex, final GadgetRequestContext gadgetRequestContext) {
        try {
            return (Response)this.txTemplate.execute(new TransactionCallback(){

                public Object doInTransaction() {
                    Dashboard targetDashboard = AddGadgetHandlerImpl.this.repository.get(targetDashboardId, gadgetRequestContext);
                    Dashboard sourceDashboard = AddGadgetHandlerImpl.this.repository.get(sourceDashboardId, gadgetRequestContext);
                    Gadget gadget = sourceDashboard.findGadget(gadgetId);
                    if (gadget == null) {
                        throw new InconsistentDashboardStateException("Gadget not found with id '" + gadgetId + "' in dashboard with id '" + sourceDashboardId + "'.");
                    }
                    if (sourceDashboardId.equals((Object)targetDashboardId)) {
                        return Response.noContent().build();
                    }
                    sourceDashboard.removeGadget(gadgetId);
                    GadgetLayout layout = AddGadgetHandlerImpl.this.createNewGadgetLayout(targetDashboard, gadgetId, columnIndex, rowIndex);
                    targetDashboard.addGadget(gadget);
                    targetDashboard.rearrangeGadgets(layout);
                    AddGadgetHandlerImpl.this.repository.save(sourceDashboard);
                    AddGadgetHandlerImpl.this.repository.save(targetDashboard);
                    return AddGadgetHandlerImpl.this.representationFactory.createGadgetRepresentation(targetDashboardId, gadget, gadgetRequestContext, true, columnIndex).fold((Supplier)new Supplier<Response>(){

                        public Response get() {
                            return AddGadgetHandlerImpl.this.notFound(AddGadgetHandlerImpl.this.i18n.getText("gadget.spec.not.allowed"));
                        }
                    }, (Function)new Function<GadgetRepresentation, Response>(){

                        public Response apply(GadgetRepresentation representation) {
                            return Response.ok().location(URI.create(representation.getGadgetUrl())).entity((Object)representation).build();
                        }
                    });
                }
            });
        }
        catch (InconsistentDashboardStateException idse) {
            this.log.error((Object)"AddGadgetHandlerImpl: Unexpected error occurred", (Throwable)idse);
            return Response.status((Response.Status)Response.Status.CONFLICT).type("text/plain").entity((Object)this.i18n.getText("error.please.reload")).build();
        }
    }

    private GadgetLayout createNewGadgetLayout(Dashboard dashboard, GadgetId movedGadgetId, DashboardState.ColumnIndex column, int row) {
        Layout layout = dashboard.getLayout();
        ArrayList columns = new ArrayList(layout.getNumberOfColumns());
        for (DashboardState.ColumnIndex dashboardColumn : layout.getColumnRange()) {
            ArrayList<GadgetId> gadgets = new ArrayList<GadgetId>();
            for (Gadget gadget : dashboard.getGadgetsInColumn(dashboardColumn)) {
                gadgets.add(gadget.getId());
            }
            if (dashboardColumn.equals((Object)column)) {
                if (row < gadgets.size()) {
                    gadgets.add(row, movedGadgetId);
                } else {
                    gadgets.add(movedGadgetId);
                }
            }
            columns.add(gadgets);
        }
        return new GadgetLayout(columns);
    }

    private Response notFound() {
        return this.notFound((Option<String>)Option.none());
    }

    private Response notFound(String text) {
        return this.notFound((Option<String>)Option.option((Object)text));
    }

    private Response notFound(Option<String> entity) {
        final Response.ResponseBuilder responseBuilder = Response.status((Response.Status)Response.Status.NOT_FOUND).type("text/plain");
        entity.foreach((Effect)new Effect<String>(){

            public void apply(String text) {
                responseBuilder.entity((Object)text);
            }
        });
        return responseBuilder.build();
    }
}

