/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.gadgets.dashboard.internal.impl;

import com.atlassian.fugue.Option;
import com.atlassian.gadgets.DashboardItemModuleId;
import com.atlassian.gadgets.DashboardItemState;
import com.atlassian.gadgets.DashboardItemStateVisitor;
import com.atlassian.gadgets.GadgetId;
import com.atlassian.gadgets.GadgetRequestContext;
import com.atlassian.gadgets.GadgetState;
import com.atlassian.gadgets.LocalDashboardItemState;
import com.atlassian.gadgets.OpenSocialDashboardItemModuleId;
import com.atlassian.gadgets.dashboard.DashboardItemModules;
import com.atlassian.gadgets.dashboard.internal.Gadget;
import com.atlassian.gadgets.dashboard.internal.GadgetFactory;
import com.atlassian.gadgets.dashboard.internal.impl.BackwardCompatibleGadgetStateFactory;
import com.atlassian.gadgets.dashboard.internal.impl.DashboardItem;
import com.atlassian.gadgets.dashboard.internal.impl.OpenSocialDashboardItem;
import com.atlassian.gadgets.dashboard.internal.impl.OpenSocialGadget;
import com.atlassian.gadgets.dashboard.internal.util.HelpLinkResolver;
import com.atlassian.gadgets.dashboard.spi.DashboardItemStateFactory;
import com.atlassian.gadgets.plugins.DashboardItemModule;
import com.atlassian.gadgets.plugins.DashboardItemModuleDescriptor;
import com.atlassian.gadgets.spec.GadgetSpecFactory;
import com.atlassian.gadgets.util.I18nFunction;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.HelpPathResolver;
import com.atlassian.sal.api.message.I18nResolver;
import com.google.common.base.Function;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GadgetFactoryImpl
implements GadgetFactory {
    private final DashboardItemStateFactory stateFactory;
    private final GadgetSpecFactory specFactory;
    private final I18nResolver i18n;
    private final HelpLinkResolver linkResolver;
    private final DashboardItemModules dashboardItemModules;

    @Autowired
    public GadgetFactoryImpl(@ComponentImport GadgetSpecFactory specFactory, @ComponentImport I18nResolver i18n, @ComponentImport HelpPathResolver helpPathResolver, DashboardItemModules dashboardItemModules, BackwardCompatibleGadgetStateFactory stateFactory) {
        this.stateFactory = stateFactory.getDashboardItemStateFactory();
        this.specFactory = specFactory;
        this.i18n = i18n;
        this.linkResolver = new HelpLinkResolver(helpPathResolver);
        this.dashboardItemModules = dashboardItemModules;
    }

    @Override
    public Gadget createDashboardItem(DashboardItemModuleId moduleId, GadgetRequestContext gadgetRequestContext) {
        DashboardItemState state = this.stateFactory.createDashboardItemState(moduleId);
        return this.createDashboardItem(state, gadgetRequestContext);
    }

    @Override
    public Gadget createDashboardItem(DashboardItemState state, final GadgetRequestContext gadgetRequestContext) {
        return (Gadget)state.accept((DashboardItemStateVisitor)new DashboardItemStateVisitor<Gadget>(){

            public Gadget visit(GadgetState gadgetState) {
                return GadgetFactoryImpl.this.createSpecificationBasedGadget(gadgetState, gadgetRequestContext);
            }

            public Gadget visit(LocalDashboardItemState dashboardItemState) {
                return GadgetFactoryImpl.this.createLocalDashboardItem(dashboardItemState, gadgetRequestContext);
            }
        });
    }

    private Gadget createLocalDashboardItem(LocalDashboardItemState state, GadgetRequestContext gadgetRequestContext) {
        Option dashboardItemModuleDescriptor = this.dashboardItemModules.getDashboardItemForModuleKey(state.getDashboardItemModuleId().getFullModuleKey());
        if (dashboardItemModuleDescriptor.isDefined()) {
            DashboardItemModuleDescriptor descriptor = (DashboardItemModuleDescriptor)dashboardItemModuleDescriptor.get();
            DashboardItemModule.DirectoryDefinition directoryDefinition = (DashboardItemModule.DirectoryDefinition)descriptor.getDirectoryDefinition().get();
            String dashboardItemTitle = (String)directoryDefinition.getTitleI18nKey().map((Function)new I18nFunction(this.i18n)).getOrElse((Object)directoryDefinition.getTitle());
            return new DashboardItem(state.getId(), dashboardItemTitle, state.getColor(), state, (DashboardItemModule)descriptor.getModule(), state.getProperties());
        }
        if (state.getDashboardItemModuleId().getReplacedGadgetId().isDefined()) {
            return this.createSpecificationBasedGadget(this.mapLocalStateToGadgetState(state), gadgetRequestContext);
        }
        return new OpenSocialGadget(this.mapLocalStateToGadgetState(state), this.i18n.getText("gadget.error.probably.uninstalled", new Serializable[]{state.getDashboardItemModuleId().getFullModuleKey().getPluginKey()}));
    }

    private GadgetState mapLocalStateToGadgetState(LocalDashboardItemState state) {
        URI specUri = (URI)state.getDashboardItemModuleId().getReplacedGadgetId().map((Function)new Function<OpenSocialDashboardItemModuleId, URI>(){

            public URI apply(OpenSocialDashboardItemModuleId input) {
                return input.getSpecUri();
            }
        }).getOrElse((Object)URI.create(""));
        return GadgetState.gadget((GadgetId)state.getId()).specUri(specUri).color(state.getColor()).userPrefs(state.getProperties()).build();
    }

    private Gadget createSpecificationBasedGadget(GadgetState state, GadgetRequestContext gadgetRequestContext) {
        Option<DashboardItemModuleDescriptor> dashboardItemDescriptor = this.getDashboardItemDescriptor(state);
        try {
            if (dashboardItemDescriptor.isDefined()) {
                DashboardItemModuleDescriptor descriptor = (DashboardItemModuleDescriptor)dashboardItemDescriptor.get();
                return new OpenSocialDashboardItem(state, (DashboardItemModule)descriptor.getModule(), descriptor.getCompleteKey(), this.specFactory.getGadgetSpec(state, gadgetRequestContext));
            }
            return new OpenSocialGadget(state, this.specFactory.getGadgetSpec(state, gadgetRequestContext));
        }
        catch (Exception ex) {
            String exceptionMsg = ex.getMessage();
            String errorMessage = exceptionMsg != null && exceptionMsg.contains("HTTP error 403") ? this.i18n.getText("gadget.error.loading", new Serializable[]{state.getGadgetSpecUri(), this.i18n.getText("gadget.403.error", new Serializable[]{state.getGadgetSpecUri(), this.linkResolver.getLink("whitelist.external.gadget")})}) : this.i18n.getText("gadget.error.loading", new Serializable[]{state.getGadgetSpecUri(), exceptionMsg});
            if (gadgetRequestContext.isDebuggingEnabled()) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter((Writer)sw, true);
                ex.printStackTrace(pw);
                return new OpenSocialGadget(state, String.format("%s\nGadget ID: %s\nStack trace: %s", errorMessage, state.getId(), sw.toString()));
            }
            return new OpenSocialGadget(state, errorMessage);
        }
    }

    private Option<DashboardItemModuleDescriptor> getDashboardItemDescriptor(GadgetState state) {
        String uri = state.getGadgetSpecUri().toASCIIString();
        return this.dashboardItemModules.getDashboardItemModuleDescriptor(uri);
    }
}

