/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.gadgets.dashboard.internal.impl;

import com.atlassian.gadgets.GadgetId;
import com.atlassian.gadgets.dashboard.DashboardId;
import com.atlassian.gadgets.dashboard.internal.DashboardUrlBuilder;
import com.atlassian.gadgets.util.AbstractUrlBuilder;
import com.atlassian.gadgets.util.Uri;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.atlassian.sal.api.ApplicationProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DashboardUrlBuilderImpl
extends AbstractUrlBuilder
implements DashboardUrlBuilder {
    @Autowired
    public DashboardUrlBuilderImpl(@ComponentImport ApplicationProperties applicationProperties, @ComponentImport WebResourceUrlProvider webResourceUrlProvider) {
        super(applicationProperties, webResourceUrlProvider, "com.atlassian.gadgets.dashboard:dashboard-servlet");
    }

    protected String getBaseUrl() {
        return this.applicationProperties.getBaseUrl() + "/rest/dashboards/1.0/";
    }

    @Override
    public String buildDashboardUrl(DashboardId dashboardId) {
        return this.getBaseUrl() + dashboardId;
    }

    @Override
    public String buildDashboardLayoutUrl(DashboardId dashboardId) {
        return this.buildDashboardUrl(dashboardId) + "/layout";
    }

    @Override
    public String buildGadgetUrl(DashboardId dashboardId, GadgetId gadgetId) {
        return this.buildDashboardUrl(dashboardId) + "/gadget/" + gadgetId;
    }

    @Override
    public String buildGadgetColorUrl(DashboardId dashboardId, GadgetId gadgetId) {
        return this.buildGadgetUrl(dashboardId, gadgetId) + "/color";
    }

    @Override
    public String buildGadgetUserPrefsUrl(DashboardId dashboardId, GadgetId gadgetId) {
        return this.buildGadgetUrl(dashboardId, gadgetId) + "/prefs";
    }

    @Override
    public String buildErrorGadgetUrl() {
        return this.applicationProperties.getBaseUrl() + "/plugins/servlet/gadgets/error/spec-not-found";
    }

    @Override
    public String buildDashboardResourceUrl(DashboardId dashboardId) {
        return this.applicationProperties.getBaseUrl() + "/rest/dashboards/1.0/" + dashboardId;
    }

    @Override
    public String buildDashboardDirectoryResourceUrl() {
        return this.applicationProperties.getBaseUrl() + "/rest/config/1.0/directory";
    }

    @Override
    public String buildDashboardDirectoryBaseUrl() {
        return Uri.ensureTrailingSlash((String)this.applicationProperties.getBaseUrl());
    }

    @Override
    public String buildDashboardDirectoryUrl(DashboardId dashboardId) {
        return this.getBaseUrl() + "/directory/" + dashboardId;
    }

    @Override
    public String buildSubscribedGadgetFeedsUrl() {
        return this.buildDashboardDirectoryResourceUrl() + "/subscribed-gadget-feeds";
    }

    @Override
    public String buildDashboardDiagnosticsRelativeUrl() {
        return Uri.create((String)(this.applicationProperties.getBaseUrl() + "/plugins/servlet/gadgets/dashboard-diagnostics")).getPath();
    }

    @Override
    public String buildSecurityTokensUrl() {
        return this.applicationProperties.getBaseUrl() + "/plugins/servlet/gadgets/security-tokens";
    }

    @Override
    public String buildGadgetDirectoryAdminRelativeUrl() {
        return this.applicationProperties.getBaseUrl() + "/plugins/servlet/gadgets/admin";
    }
}

