/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.gadgets.dashboard.internal.impl;

import com.atlassian.fugue.Option;
import com.atlassian.gadgets.GadgetId;
import com.atlassian.gadgets.dashboard.DashboardId;
import com.atlassian.gadgets.dashboard.DashboardNotFoundException;
import com.atlassian.gadgets.dashboard.DashboardService;
import com.atlassian.gadgets.dashboard.DashboardState;
import com.atlassian.gadgets.dashboard.PermissionException;
import com.atlassian.gadgets.dashboard.internal.impl.TransactionalDashboardStateStoreImpl;
import com.atlassian.gadgets.dashboard.spi.DashboardPermissionService;
import com.atlassian.gadgets.dashboard.spi.DashboardStateStore;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="dashboardService")
@ExportAsService
public class DashboardServiceImpl
implements DashboardService {
    private static final Logger log = LoggerFactory.getLogger(DashboardServiceImpl.class);
    private final DashboardStateStore stateStore;
    private final DashboardPermissionService permissionService;

    @Autowired
    public DashboardServiceImpl(TransactionalDashboardStateStoreImpl stateStore, @ComponentImport DashboardPermissionService permissionService) {
        this.stateStore = stateStore;
        this.permissionService = permissionService;
    }

    public DashboardState get(DashboardId id, String username) throws PermissionException {
        if (!this.permissionService.isReadableBy(id, username)) {
            throw new PermissionException();
        }
        return this.stateStore.retrieve(id);
    }

    public DashboardState save(DashboardState state, String username) throws PermissionException {
        if (!this.permissionService.isWritableBy(state.getId(), username)) {
            throw new PermissionException();
        }
        return this.stateStore.update(state, (Iterable)ImmutableList.of());
    }

    public Option<DashboardState> getDashboardForGadget(GadgetId gadgetId, final String username) throws PermissionException {
        return this.getDashboardStateFromStore(gadgetId).map((Function)new Function<DashboardState, DashboardState>(){

            public DashboardState apply(DashboardState input) {
                if (!DashboardServiceImpl.this.permissionService.isReadableBy(input.getId(), username)) {
                    throw new PermissionException();
                }
                return input;
            }
        });
    }

    private Option<DashboardState> getDashboardStateFromStore(GadgetId gadgetId) {
        try {
            return Option.option((Object)this.stateStore.findDashboardWithGadget(gadgetId));
        }
        catch (DashboardNotFoundException ex) {
            return Option.none();
        }
        catch (RuntimeException ex) {
            log.warn(String.format("unexpected exception when retrieving dashboard for dashboard item %s", gadgetId), (Throwable)ex);
            return Option.none();
        }
    }
}

