/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.gadgets.dashboard.internal.impl;

import com.atlassian.gadgets.GadgetId;
import com.atlassian.gadgets.GadgetRequestContext;
import com.atlassian.gadgets.dashboard.DashboardId;
import com.atlassian.gadgets.dashboard.DashboardNotFoundException;
import com.atlassian.gadgets.dashboard.DashboardState;
import com.atlassian.gadgets.dashboard.internal.Dashboard;
import com.atlassian.gadgets.dashboard.internal.DashboardRepository;
import com.atlassian.gadgets.dashboard.internal.InconsistentDashboardStateException;
import com.atlassian.gadgets.dashboard.internal.StateConverter;
import com.atlassian.gadgets.dashboard.internal.impl.TransactionalDashboardStateStoreImpl;
import com.atlassian.gadgets.dashboard.spi.DashboardStateStore;
import com.google.common.base.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DashboardRepositoryImpl
implements DashboardRepository {
    private final DashboardStateStore stateStore;
    private final StateConverter converter;

    @Autowired
    public DashboardRepositoryImpl(TransactionalDashboardStateStoreImpl stateStore, StateConverter converter) {
        this.stateStore = stateStore;
        this.converter = converter;
    }

    @Override
    public Dashboard get(DashboardId dashboardId, GadgetRequestContext gadgetRequestContext) throws DashboardNotFoundException {
        return this.converter.convertStateToDashboard(this.stateStore.retrieve(dashboardId), gadgetRequestContext);
    }

    @Override
    public void save(Dashboard dashboard) {
        DashboardState state = dashboard.getState();
        if (!Objects.equal((Object)this.stateStore.update(state, dashboard.getChanges()), (Object)state)) {
            throw new InconsistentDashboardStateException("Dashboard state after store does not match state provided to store");
        }
        dashboard.clearChanges();
    }

    @Override
    public DashboardId findDashboardByGadgetId(GadgetId gadgetId) throws DashboardNotFoundException {
        return this.stateStore.findDashboardWithGadget(gadgetId).getId();
    }
}

