/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.gadgets.dashboard.internal.impl;

import com.atlassian.fugue.Option;
import com.atlassian.gadgets.DashboardItemModuleId;
import com.atlassian.gadgets.DashboardItemType;
import com.atlassian.gadgets.GadgetSpecUriNotAllowedException;
import com.atlassian.gadgets.LocalDashboardItemModuleId;
import com.atlassian.gadgets.OpenSocialDashboardItemModuleId;
import com.atlassian.gadgets.dashboard.DashboardItemModules;
import com.atlassian.gadgets.plugins.DashboardItemModuleDescriptor;
import com.atlassian.plugin.ModuleCompleteKey;
import com.google.common.base.Function;
import com.google.common.base.Supplier;
import java.net.URI;
import java.net.URISyntaxException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DashboardItemModuleIdFactory {
    private final DashboardItemModules dashboardItemModules;

    @Autowired
    public DashboardItemModuleIdFactory(DashboardItemModules dashboardItemModules) {
        this.dashboardItemModules = dashboardItemModules;
    }

    public Option<DashboardItemModuleId> createDashboardItemModuleId(DashboardItemType type, String id) throws GadgetSpecUriNotAllowedException {
        switch (type) {
            case LOCAL_DASHBOARD_ITEM: {
                return this.createLocalModuleId(id);
            }
            case OPEN_SOCIAL_GADGET: {
                return DashboardItemModuleIdFactory.createOpenSocialModuleId(id);
            }
        }
        return Option.none();
    }

    private Option<DashboardItemModuleId> createLocalModuleId(String id) {
        final ModuleCompleteKey moduleCompleteKey = new ModuleCompleteKey(id);
        Option moduleDescriptor = this.dashboardItemModules.getDashboardItemForModuleKey(moduleCompleteKey);
        if (moduleDescriptor.isDefined()) {
            DashboardItemModuleDescriptor dashboardItemModuleDescriptor = (DashboardItemModuleDescriptor)moduleDescriptor.get();
            return (Option)dashboardItemModuleDescriptor.getGadgetSpecUriToReplace().fold((Supplier)new Supplier<Option<DashboardItemModuleId>>(){

                public Option<DashboardItemModuleId> get() {
                    return Option.some((Object)new LocalDashboardItemModuleId(moduleCompleteKey));
                }
            }, (Function)new Function<String, Option<DashboardItemModuleId>>(){

                public Option<DashboardItemModuleId> apply(String uriToReplace) {
                    return Option.some((Object)new LocalDashboardItemModuleId(moduleCompleteKey, DashboardItemModuleIdFactory.createOpenSocialModuleId(uriToReplace)));
                }
            });
        }
        return Option.none();
    }

    private static Option<OpenSocialDashboardItemModuleId> createOpenSocialModuleId(String uri) {
        try {
            return Option.option((Object)new OpenSocialDashboardItemModuleId(new URI(uri)));
        }
        catch (URISyntaxException e) {
            return Option.none();
        }
    }
}

