/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.gadgets.dashboard.internal.impl;

import com.atlassian.gadgets.DashboardItemState;
import com.atlassian.gadgets.DashboardItemStateVisitor;
import com.atlassian.gadgets.GadgetId;
import com.atlassian.gadgets.GadgetNotFoundException;
import com.atlassian.gadgets.GadgetRequestContext;
import com.atlassian.gadgets.GadgetState;
import com.atlassian.gadgets.LocalDashboardItemState;
import com.atlassian.gadgets.dashboard.Color;
import com.atlassian.gadgets.dashboard.DashboardId;
import com.atlassian.gadgets.dashboard.DashboardState;
import com.atlassian.gadgets.dashboard.Layout;
import com.atlassian.gadgets.dashboard.internal.Dashboard;
import com.atlassian.gadgets.dashboard.internal.Gadget;
import com.atlassian.gadgets.dashboard.internal.GadgetLayoutException;
import com.atlassian.gadgets.dashboard.internal.StateConverter;
import com.atlassian.gadgets.dashboard.internal.UserPref;
import com.atlassian.gadgets.dashboard.spi.GadgetLayout;
import com.atlassian.gadgets.dashboard.spi.changes.AddGadgetChange;
import com.atlassian.gadgets.dashboard.spi.changes.DashboardChange;
import com.atlassian.gadgets.dashboard.spi.changes.GadgetColorChange;
import com.atlassian.gadgets.dashboard.spi.changes.RemoveGadgetChange;
import com.atlassian.gadgets.dashboard.spi.changes.UpdateGadgetUserPrefsChange;
import com.atlassian.gadgets.dashboard.spi.changes.UpdateLayoutChange;
import com.atlassian.gadgets.spec.DataType;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class DashboardImpl
implements Dashboard {
    private DashboardState state;
    private StateConverter stateConverter;
    private List<DashboardChange> changes = Lists.newArrayList();
    private final GadgetRequestContext gadgetRequestContext;

    public DashboardImpl(DashboardState state, StateConverter stateConverter, GadgetRequestContext gadgetRequestContext) {
        this.state = (DashboardState)Preconditions.checkNotNull((Object)state, (Object)"state");
        this.stateConverter = (StateConverter)Preconditions.checkNotNull((Object)stateConverter, (Object)"stateConverter");
        this.gadgetRequestContext = (GadgetRequestContext)Preconditions.checkNotNull((Object)gadgetRequestContext, (Object)"gadgetRequestContext");
    }

    @Override
    public DashboardId getId() {
        return this.state.getId();
    }

    @Override
    public String getTitle() {
        return this.state.getTitle();
    }

    @Override
    public Layout getLayout() {
        return this.state.getLayout();
    }

    @Override
    public Iterable<Gadget> getGadgetsInColumn(DashboardState.ColumnIndex column) {
        if (!this.getLayout().contains(column)) {
            throw new IllegalArgumentException("Invalid column index for layout " + this.getLayout());
        }
        return Iterables.transform((Iterable)this.state.getDashboardColumns().getItemsInColumn(column), this.toDashboardItems());
    }

    @Override
    public void appendGadget(Gadget gadget) {
        this.appendGadget(DashboardState.ColumnIndex.ZERO, gadget);
    }

    @Override
    public void appendGadget(DashboardState.ColumnIndex columnIndex, Gadget gadget) {
        this.state = this.state.appendItemToColumn(gadget.getState(), columnIndex);
        this.changes.add((DashboardChange)new AddGadgetChange(gadget.getState(), columnIndex, Iterables.size((Iterable)this.state.getDashboardColumns().getItemsInColumn(columnIndex)) - 1));
    }

    @Override
    public void addGadget(Gadget gadget) {
        this.addGadget(DashboardState.ColumnIndex.ZERO, gadget);
    }

    @Override
    public void addGadget(DashboardState.ColumnIndex column, Gadget gadget) {
        this.state = this.state.prependItemToColumn(gadget.getState(), column);
        this.changes.add((DashboardChange)new AddGadgetChange(gadget.getState(), column, 0));
    }

    @Override
    public void changeLayout(Layout layout, GadgetLayout gadgetLayout) throws GadgetLayoutException {
        this.assertGadgetLayoutIsValid(layout, gadgetLayout);
        this.assertAllGadgetsPresent(gadgetLayout);
        this.state = DashboardState.dashboard((DashboardState)this.state).layout(layout).dashboardColumns(this.getRearrangedColumns(layout, gadgetLayout)).build();
        this.changes.add((DashboardChange)new UpdateLayoutChange(layout, gadgetLayout));
    }

    @Override
    public void rearrangeGadgets(GadgetLayout gadgetLayout) throws GadgetLayoutException {
        this.assertGadgetLayoutIsValid(this.getLayout(), gadgetLayout);
        this.assertAllGadgetsPresent(gadgetLayout);
        this.state = DashboardState.dashboard((DashboardState)this.state).dashboardColumns(this.getRearrangedColumns(this.getLayout(), gadgetLayout)).build();
        this.changes.add((DashboardChange)new UpdateLayoutChange(this.getLayout(), gadgetLayout));
    }

    @Override
    public void changeGadgetColor(GadgetId gadgetId, Color color) {
        Preconditions.checkNotNull((Object)gadgetId, (Object)"gadgetId");
        Preconditions.checkNotNull((Object)color, (Object)"color");
        try {
            this.state = DashboardState.dashboard((DashboardState)this.state).dashboardColumns(this.updateGadget(this.withId(gadgetId), this.changeColorTo(color))).build();
            this.changes.add((DashboardChange)new GadgetColorChange(gadgetId, color));
        }
        catch (InternalGadgetNotFoundException e) {
            throw new GadgetNotFoundException(gadgetId);
        }
    }

    @Override
    public void updateGadgetUserPrefs(GadgetId gadgetId, Map<String, String> prefValues) {
        Preconditions.checkNotNull((Object)gadgetId, (Object)"gadgetId");
        Preconditions.checkNotNull(prefValues, (Object)"prefValues");
        try {
            this.state = DashboardState.dashboard((DashboardState)this.state).dashboardColumns(this.updateGadget(this.withId(gadgetId), this.updateUserPrefs(prefValues))).build();
            this.changes.add((DashboardChange)new UpdateGadgetUserPrefsChange(gadgetId, prefValues));
        }
        catch (InternalGadgetNotFoundException e) {
            throw new GadgetNotFoundException(gadgetId);
        }
    }

    @Override
    public DashboardState.ColumnIndex getGadgetColumn(GadgetId gadgetId) {
        for (DashboardState.ColumnIndex columnIndex : this.getLayout().getColumnRange()) {
            for (DashboardItemState dashboardItemState : this.state.getDashboardColumns().getItemsInColumn(columnIndex)) {
                if (!this.withId(gadgetId).apply((Object)dashboardItemState)) continue;
                return columnIndex;
            }
        }
        return null;
    }

    @Override
    public void removeGadget(GadgetId gadgetId) {
        this.state = DashboardState.dashboard((DashboardState)this.state).dashboardColumns(Iterables.transform((Iterable)this.state.getDashboardColumns().getColumns(), this.removeGadget(this.withId(gadgetId)))).build();
        this.changes.add((DashboardChange)new RemoveGadgetChange(gadgetId));
    }

    @Override
    public DashboardState getState() {
        return this.state;
    }

    @Override
    public Gadget findGadget(GadgetId gadgetId) {
        for (DashboardState.ColumnIndex columnIndex : this.getLayout().getColumnRange()) {
            for (DashboardItemState dashboardItemState : this.state.getDashboardColumns().getItemsInColumn(columnIndex)) {
                if (!this.withId(gadgetId).apply((Object)dashboardItemState)) continue;
                return (Gadget)this.toDashboardItems().apply((Object)dashboardItemState);
            }
        }
        return null;
    }

    @Override
    public List<DashboardChange> getChanges() {
        return ImmutableList.copyOf(this.changes);
    }

    @Override
    public void clearChanges() {
        this.changes = Lists.newArrayList();
    }

    private Function<DashboardItemState, Gadget> toDashboardItems() {
        return new DashboardItemStateConverter();
    }

    private Function<DashboardItemState, DashboardItemState> changeColorTo(Color color) {
        return new ChangeColorTo(color);
    }

    private Function<DashboardItemState, DashboardItemState> updateUserPrefs(Map<String, String> prefValues) {
        return new UpdatePrefValues(prefValues);
    }

    private Iterable<? extends Iterable<DashboardItemState>> updateGadget(Predicate<DashboardItemState> predicate, Function<DashboardItemState, DashboardItemState> function) {
        Preconditions.checkNotNull(predicate, (Object)"predicate");
        Preconditions.checkNotNull(function, (Object)"function");
        boolean foundGadget = false;
        ImmutableList.Builder columnsBuilder = ImmutableList.builder();
        for (Iterable column : this.state.getDashboardColumns().getColumns()) {
            ImmutableList.Builder columnBuilder = ImmutableList.builder();
            for (DashboardItemState dashboardItemState : column) {
                if (predicate.apply((Object)dashboardItemState)) {
                    foundGadget = true;
                    columnBuilder.add(function.apply((Object)dashboardItemState));
                    continue;
                }
                columnBuilder.add((Object)dashboardItemState);
            }
            columnsBuilder.add((Object)columnBuilder.build());
        }
        if (!foundGadget) {
            throw new InternalGadgetNotFoundException();
        }
        return columnsBuilder.build();
    }

    private Map<String, String> updatedUserPrefs(Gadget gadget, Map<String, String> prefsToUpdate) {
        HashMap newUserPrefs = Maps.newHashMap();
        HashMap definedUserPrefs = Maps.newHashMap();
        for (UserPref userPref : gadget.getUserPrefs()) {
            definedUserPrefs.put(userPref.getName(), userPref);
            newUserPrefs.put(userPref.getName(), userPref.getValue());
        }
        for (Map.Entry entry : prefsToUpdate.entrySet()) {
            String key = (String)entry.getKey();
            if (definedUserPrefs.containsKey(key)) {
                UserPref userPref = (UserPref)definedUserPrefs.get(key);
                String newValue = prefsToUpdate.get(userPref.getName());
                if (DataType.BOOL.equals((Object)userPref.getDataType()) && StringUtils.isBlank((String)newValue)) {
                    newValue = Boolean.FALSE.toString();
                }
                if (userPref.isRequired() && StringUtils.isBlank((String)newValue)) {
                    throw new IllegalArgumentException("pref '" + userPref.getName() + "' is required and must have a non-null, non-empty value");
                }
                newUserPrefs.put(userPref.getName(), newValue);
                continue;
            }
            newUserPrefs.put(key, entry.getValue());
        }
        return ImmutableMap.copyOf((Map)newUserPrefs);
    }

    private Function<Iterable<DashboardItemState>, Iterable<DashboardItemState>> removeGadget(Predicate<DashboardItemState> predicate) {
        return new RemoveGadgetFunction(predicate);
    }

    private Predicate<DashboardItemState> withId(GadgetId gadgetId) {
        return new WithIdPredicate(gadgetId);
    }

    private Iterable<Iterable<DashboardItemState>> getRearrangedColumns(Layout layout, GadgetLayout gadgetLayout) {
        Map<GadgetId, DashboardItemState> gadgets = this.getAllGadgets();
        ImmutableList.Builder columnsBuilder = ImmutableList.builder();
        for (int i = 0; i < layout.getNumberOfColumns(); ++i) {
            ImmutableList.Builder columnBuilder = ImmutableList.builder();
            for (GadgetId gadgetId : gadgetLayout.getGadgetsInColumn(i)) {
                if (!gadgets.containsKey(gadgetId)) continue;
                columnBuilder.add((Object)gadgets.get(gadgetId));
                gadgets.remove(gadgetId);
            }
            columnsBuilder.add((Object)columnBuilder.build());
        }
        return columnsBuilder.build();
    }

    private Map<GadgetId, DashboardItemState> getAllGadgets() {
        HashMap<GadgetId, DashboardItemState> gadgets = new HashMap<GadgetId, DashboardItemState>();
        for (Iterable column : this.state.getDashboardColumns().getColumns()) {
            for (DashboardItemState gadgetState : column) {
                gadgets.put(gadgetState.getId(), gadgetState);
            }
        }
        return gadgets;
    }

    @Override
    public int getNumberOfGadgets() {
        int numberOfGadgets = 0;
        for (Iterable column : this.state.getDashboardColumns().getColumns()) {
            numberOfGadgets += Iterables.size((Iterable)column);
        }
        return numberOfGadgets;
    }

    private void assertAllGadgetsPresent(GadgetLayout gadgetLayout) throws GadgetLayoutException {
        Map<GadgetId, DashboardItemState> gadgets = this.getAllGadgets();
        for (int i = 0; i < gadgetLayout.getNumberOfColumns(); ++i) {
            for (GadgetId gadgetId : gadgetLayout.getGadgetsInColumn(i)) {
                gadgets.remove(gadgetId);
            }
        }
        if (!gadgets.isEmpty()) {
            throw new GadgetLayoutException("Gadgets cannot be removed by changing the layout, they need to be removed explicitly");
        }
    }

    public void assertGadgetLayoutIsValid(Layout layout, GadgetLayout gadgetLayout) throws GadgetLayoutException {
        if (gadgetLayout.getNumberOfColumns() > layout.getNumberOfColumns()) {
            throw new GadgetLayoutException("New layout has " + gadgetLayout.getNumberOfColumns() + " but the current layout only allows " + layout.getNumberOfColumns() + " columns.");
        }
    }

    private static final class WithIdPredicate
    implements Predicate<DashboardItemState> {
        private final GadgetId gadgetId;

        public WithIdPredicate(GadgetId gadgetId) {
            this.gadgetId = gadgetId;
        }

        public boolean apply(DashboardItemState gadgetState) {
            return gadgetState.getId().equals((Object)this.gadgetId);
        }
    }

    private static final class RemoveGadgetFunction
    implements Function<Iterable<DashboardItemState>, Iterable<DashboardItemState>> {
        private final Predicate<DashboardItemState> predicate;

        public RemoveGadgetFunction(Predicate<DashboardItemState> predicate) {
            this.predicate = predicate;
        }

        public Iterable<DashboardItemState> apply(Iterable<DashboardItemState> column) {
            return Iterables.filter(column, (Predicate)Predicates.not(this.predicate));
        }
    }

    private static final class InternalGadgetNotFoundException
    extends RuntimeException {
        private InternalGadgetNotFoundException() {
        }
    }

    private final class UpdatePrefValues
    implements Function<DashboardItemState, DashboardItemState> {
        private final Map<String, String> newPrefValues;

        public UpdatePrefValues(Map<String, String> newPrefValues) {
            this.newPrefValues = newPrefValues;
        }

        public DashboardItemState apply(DashboardItemState dashboardItemState) {
            return (DashboardItemState)dashboardItemState.accept((DashboardItemStateVisitor)new DashboardItemStateVisitor<DashboardItemState>(){

                public DashboardItemState visit(GadgetState openSocialGadgetState) {
                    return GadgetState.gadget((GadgetState)openSocialGadgetState).userPrefs(DashboardImpl.this.updatedUserPrefs(DashboardImpl.this.stateConverter.convertStateToGadget((DashboardItemState)openSocialGadgetState, DashboardImpl.this.gadgetRequestContext), UpdatePrefValues.this.newPrefValues)).build();
                }

                public DashboardItemState visit(LocalDashboardItemState dashboardItemState) {
                    return dashboardItemState;
                }
            });
        }
    }

    private static final class ChangeColorTo
    implements Function<DashboardItemState, DashboardItemState> {
        private final Color color;

        public ChangeColorTo(Color color) {
            this.color = color;
        }

        public DashboardItemState apply(DashboardItemState dashboardItemState) {
            return (DashboardItemState)dashboardItemState.accept((DashboardItemStateVisitor)new DashboardItemStateVisitor<DashboardItemState>(){

                public DashboardItemState visit(GadgetState openSocialGadgetState) {
                    return GadgetState.gadget((GadgetState)openSocialGadgetState).color(color).build();
                }

                public DashboardItemState visit(LocalDashboardItemState dashboardItemState) {
                    return LocalDashboardItemState.builder((LocalDashboardItemState)dashboardItemState).color(color).build();
                }
            });
        }
    }

    private final class DashboardItemStateConverter
    implements Function<DashboardItemState, Gadget> {
        private DashboardItemStateConverter() {
        }

        public Gadget apply(DashboardItemState dashboardItemState) {
            return DashboardImpl.this.stateConverter.convertStateToGadget(dashboardItemState, DashboardImpl.this.gadgetRequestContext);
        }
    }
}

