/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.gadgets.dashboard.internal.impl;

import com.atlassian.fugue.Option;
import com.atlassian.gadgets.DashboardItemModuleId;
import com.atlassian.gadgets.DashboardItemModuleIdVisitor;
import com.atlassian.gadgets.DashboardItemState;
import com.atlassian.gadgets.GadgetState;
import com.atlassian.gadgets.LocalDashboardItemModuleId;
import com.atlassian.gadgets.LocalDashboardItemState;
import com.atlassian.gadgets.OpenSocialDashboardItemModuleId;
import com.atlassian.gadgets.dashboard.spi.DashboardItemStateFactory;
import com.atlassian.gadgets.dashboard.spi.GadgetStateFactory;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BackwardCompatibleGadgetStateFactory {
    private final DashboardItemStateFactory dashboardItemStateFactory;

    @Autowired
    public BackwardCompatibleGadgetStateFactory(BundleContext bundleContext) {
        DashboardItemStateFactory factory = (DashboardItemStateFactory)BackwardCompatibleGadgetStateFactory.getComponent(DashboardItemStateFactory.class, bundleContext).getOrNull();
        if (factory != null) {
            this.dashboardItemStateFactory = factory;
        } else {
            GadgetStateFactory legacyFactory = (GadgetStateFactory)Preconditions.checkNotNull((Object)BackwardCompatibleGadgetStateFactory.getComponent(GadgetStateFactory.class, bundleContext).getOrNull(), (Object)"there is not DashboardItemStateFactory or GadgetStateFactory");
            this.dashboardItemStateFactory = new GadgetStateFactoryAdapter(legacyFactory);
        }
    }

    public DashboardItemStateFactory getDashboardItemStateFactory() {
        return this.dashboardItemStateFactory;
    }

    private static <T> Option<T> getComponent(final Class<T> type, final BundleContext bundleContext) {
        return Option.option((Object)bundleContext.getServiceReference(type.getName())).map(new Function<ServiceReference, T>(){

            public T apply(ServiceReference input) {
                return type.cast(bundleContext.getService(input));
            }
        });
    }

    private static class GadgetStateFactoryAdapter
    implements DashboardItemStateFactory {
        private final GadgetStateFactory legacyFactory;

        public GadgetStateFactoryAdapter(GadgetStateFactory gadgetStateFactory) {
            this.legacyFactory = gadgetStateFactory;
        }

        public GadgetState createGadgetState(@Nonnull OpenSocialDashboardItemModuleId openSocialModuleId) {
            return this.legacyFactory.createGadgetState(openSocialModuleId.getSpecUri());
        }

        public DashboardItemState createDashboardItemState(@Nonnull DashboardItemModuleId moduleId) {
            return (DashboardItemState)moduleId.accept((DashboardItemModuleIdVisitor)new DashboardItemModuleIdVisitor<DashboardItemState>(){

                public DashboardItemState visit(OpenSocialDashboardItemModuleId openSocialDashboardItemModuleId) {
                    return legacyFactory.createGadgetState(openSocialDashboardItemModuleId.getSpecUri());
                }

                public DashboardItemState visit(LocalDashboardItemModuleId dashboardItemModuleId) {
                    if (dashboardItemModuleId.getReplacedGadgetId().isDefined()) {
                        return legacyFactory.createGadgetState(((OpenSocialDashboardItemModuleId)dashboardItemModuleId.getReplacedGadgetId().get()).getSpecUri());
                    }
                    return (DashboardItemState)this.exception();
                }
            });
        }

        public LocalDashboardItemState createLocalDashboardState(@Nonnull LocalDashboardItemModuleId dashboardItemModuleId) {
            return (LocalDashboardItemState)this.exception();
        }

        private <T> T exception() {
            throw new IllegalArgumentException("Trying to handle new dashboard item with legacy GadgetStateFactory");
        }
    }
}

