/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.gadgets.dashboard.internal.diagnostics;

import com.atlassian.gadgets.dashboard.internal.diagnostics.Diagnostics;
import com.atlassian.gadgets.dashboard.internal.diagnostics.DiagnosticsException;
import com.atlassian.gadgets.dashboard.internal.diagnostics.UrlHostnameMismatchException;
import com.atlassian.gadgets.dashboard.internal.diagnostics.UrlPortMismatchException;
import com.atlassian.gadgets.dashboard.internal.diagnostics.UrlSchemeMismatchException;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;

@Scanned
public class DiagnosticsServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(DiagnosticsServlet.class);
    private final TemplateRenderer renderer;
    private final UserManager userManager;
    private final Diagnostics diagnostics;
    private AtomicBoolean displayResult;

    public DiagnosticsServlet(@Qualifier(value="dashboardTemplateRenderer") TemplateRenderer renderer, @ComponentImport UserManager userManager, Diagnostics diagnostics) {
        this.renderer = renderer;
        this.userManager = userManager;
        this.diagnostics = diagnostics;
        this.displayResult = new AtomicBoolean(true);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doPost(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String method = req.getParameter("method");
        if (method != null && "delete".equalsIgnoreCase(method)) {
            this.displayResult.set(false);
        } else {
            boolean isAdmin;
            String userName = this.userManager.getRemoteUsername(req);
            boolean bl = isAdmin = userName != null && this.userManager.isSystemAdmin(userName);
            if (this.displayResult.get()) {
                this.executeDiagnostics(req, resp, isAdmin);
            } else {
                resp.setStatus(200);
                resp.setContentType("text/html;charset=UTF-8");
            }
        }
    }

    private void executeDiagnostics(HttpServletRequest req, HttpServletResponse resp, boolean isAdmin) throws IOException {
        String clientDetectedUriParameter = req.getParameter("uri");
        if (clientDetectedUriParameter == null || clientDetectedUriParameter.length() == 0) {
            resp.sendError(400, "Missing required parameter: 'uri'");
            return;
        }
        URI clientDetectedUri = null;
        try {
            clientDetectedUri = new URI(clientDetectedUriParameter);
        }
        catch (URISyntaxException e) {
            resp.sendError(400, "Required 'uri' parameter must be a valid URI: " + e);
        }
        try {
            this.diagnostics.check(clientDetectedUri);
            Templates.OK.render(this.renderer, resp);
        }
        catch (UrlSchemeMismatchException e) {
            Templates.MISMATCHED_URL_SCHEME.renderError(this.renderer, e, resp, isAdmin);
        }
        catch (UrlHostnameMismatchException e) {
            Templates.MISMATCHED_URL_HOSTNAME.renderError(this.renderer, e, resp, isAdmin);
        }
        catch (UrlPortMismatchException e) {
            Templates.MISMATCHED_URL_PORT.renderError(this.renderer, e, resp, isAdmin);
        }
        catch (Exception e) {
            Templates.UNKNOWN_ERROR.renderError(this.renderer, new DiagnosticsException(e.getClass().getName() + ": " + e.getMessage(), e), resp, isAdmin);
        }
    }

    private static enum Templates {
        MISMATCHED_URL_SCHEME("mismatched-scheme.vm"),
        MISMATCHED_URL_HOSTNAME("mismatched-hostname.vm"),
        MISMATCHED_URL_PORT("mismatched-port.vm"),
        UNKNOWN_ERROR("unknown-error.vm"),
        OK("ok.vm");

        private final String templateName;

        private Templates(String templateName) {
            this.templateName = templateName;
        }

        void render(TemplateRenderer renderer, HttpServletResponse resp) throws IOException {
            resp.setContentType("text/html;charset=UTF-8");
            renderer.render("com/atlassian/gadgets/dashboard/internal/diagnostics/templates/" + this.templateName, (Writer)resp.getWriter());
        }

        void renderError(TemplateRenderer renderer, DiagnosticsException error, HttpServletResponse resp, boolean isAdmin) throws IOException {
            log.error("DIAGNOSTICS: FAILED", (Throwable)error);
            resp.setStatus(500);
            resp.setContentType("text/html;charset=UTF-8");
            renderer.render("com/atlassian/gadgets/dashboard/internal/diagnostics/templates/" + this.templateName, (Map)ImmutableMap.of((Object)"error", (Object)error, (Object)"isAdmin", (Object)isAdmin), (Writer)resp.getWriter());
        }
    }
}

