/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.gadgets.dashboard.internal;

import com.atlassian.gadgets.dashboard.internal.DashboardUrlBuilder;
import com.atlassian.gadgets.dashboard.internal.DashboardWebItemFinder;
import com.atlassian.gadgets.dashboard.internal.util.JavaScript;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.templaterenderer.RenderingException;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="dashboardTemplateRenderer")
public class DashboardTemplateRenderer
implements TemplateRenderer {
    private final TemplateRenderer renderer;
    private final DashboardUrlBuilder urlBuilder;
    private final DashboardWebItemFinder webItemFinder;
    private final ApplicationProperties applicationProperties;

    @Autowired
    public DashboardTemplateRenderer(@ComponentImport TemplateRenderer renderer, DashboardUrlBuilder urlBuilder, DashboardWebItemFinder webItemFinder, @ComponentImport ApplicationProperties applicationProperties) {
        this.urlBuilder = urlBuilder;
        this.webItemFinder = webItemFinder;
        this.applicationProperties = applicationProperties;
        this.renderer = renderer;
    }

    public void render(String templateName, Writer writer) throws RenderingException, IOException {
        this.render(templateName, Collections.emptyMap(), writer);
    }

    public void render(String templateName, Map<String, Object> context, Writer writer) throws RenderingException, IOException {
        this.renderer.render(templateName, this.createContext(context, writer), writer);
    }

    public String renderFragment(String fragment, Map<String, Object> context) {
        return this.renderer.renderFragment(fragment, this.createContext(context, null));
    }

    public boolean resolve(String templateName) {
        return this.renderer.resolve(templateName);
    }

    private Map<String, Object> createContext(Map<String, Object> contextParams, Writer writer) {
        HashMap context = Maps.newHashMap(contextParams);
        context.put("urlBuilder", this.urlBuilder);
        context.put("writer", writer);
        context.put("webItemFinder", this.webItemFinder);
        context.put("applicationProperties", this.applicationProperties);
        context.put("js", new JavaScript());
        return context;
    }
}

