/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.logging.log4j.appender.fluentd;

import java.util.LinkedList;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.log4j.spi.LoggingEvent;

@ThreadSafe
public class LoggingEventQueue {
    private final long maxNumEvents;
    volatile LinkedList<LoggingEvent> loggingEventQueue = new LinkedList();

    public LoggingEventQueue(long maxNumEvents) {
        this.maxNumEvents = maxNumEvents;
    }

    public synchronized void enqueue(LoggingEvent loggingEvent) {
        this.loggingEventQueue.add(loggingEvent);
        while ((long)this.loggingEventQueue.size() > this.maxNumEvents) {
            this.dequeue();
        }
    }

    public synchronized List<LoggingEvent> retrieveLoggingEvents(int maximum) {
        LinkedList<LoggingEvent> events = new LinkedList<LoggingEvent>();
        if (maximum < 0 || maximum >= this.loggingEventQueue.size()) {
            LinkedList<LoggingEvent> currentQueue = this.loggingEventQueue;
            this.loggingEventQueue = new LinkedList();
            return currentQueue;
        }
        for (int remaining = maximum; remaining > 0; --remaining) {
            events.add(this.dequeue());
        }
        return events;
    }

    public synchronized LoggingEvent dequeue() {
        return this.loggingEventQueue.poll();
    }

    public int getSize() {
        return this.loggingEventQueue.size();
    }

    public boolean isFull() {
        return (long)this.getSize() >= this.maxNumEvents;
    }
}

